/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.latency;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.latency.KernelCtfTraceStub;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCallLatencyAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.statistics.SystemCallLatencyStatisticsAnalysisModule;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyscallStatsAnalysisTest {
    private ITmfTrace fTestTrace;
    private SystemCallLatencyStatisticsAnalysisModule fSyscallStatsModule;

    @Before
    public void setupAnalysis() {
        KernelCtfTraceStub trace = KernelCtfTraceStub.getTrace(CtfTestTrace.ARM_64_BIT_HEADER);
        this.fTestTrace = trace;
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, SystemCallLatencyAnalysis.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        SystemCallLatencyStatisticsAnalysisModule syscallStatsModule = null;
        for (IAnalysisModule mod : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, SystemCallLatencyStatisticsAnalysisModule.class)) {
            syscallStatsModule = (SystemCallLatencyStatisticsAnalysisModule)mod;
        }
        Assert.assertNotNull(syscallStatsModule);
        syscallStatsModule.schedule();
        syscallStatsModule.waitForCompletion();
        this.fSyscallStatsModule = syscallStatsModule;
    }

    @After
    public void cleanup() {
        ITmfTrace testTrace = this.fTestTrace;
        if (testTrace != null) {
            testTrace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSmallTraceSequential() {
        SystemCallLatencyStatisticsAnalysisModule syscallStatsModule = this.fSyscallStatsModule;
        Assert.assertNotNull((Object)syscallStatsModule);
        @NonNull IStatistics totalStats = syscallStatsModule.getStatsTotal();
        Assert.assertNotNull((Object)totalStats);
        Assert.assertEquals((long)1801L, (long)totalStats.getNbElements());
        Assert.assertEquals((long)5904091700L, (long)totalStats.getMax());
    }
}

