/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.regex.Matcher;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public class DotNotationChainContext
extends ProposalContext {
    public DotNotationChainContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        Matcher matcher = this.proposalContextInfo.matcher;
        String varName = matcher.group(1);
        CompilationTimeStamp timestamp = this.proposalContextInfo.module.getLastCompilationTimeStamp();
        Reference reference = TTCN3ReferenceAnalyzer.parseForCompletion(this.proposalContextInfo.file, varName);
        if (reference == null || this.proposalContextInfo.scope == null) {
            return;
        }
        Assignment assignment = this.proposalContextInfo.scope.getAssBySRef(timestamp, reference);
        if (assignment == null) {
            return;
        }
        String prefix = this.getPrefix();
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        if (assignment instanceof Def_Timer) {
            DotNotationChainContext.addProposal("start", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addProposal("stop", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addProposal("read", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addProposal("running", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addProposal("timeout", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("start", "start( ${seconds} );", "start( seconds )", "", propCollector, replacementOffset, replacementLength, prefix);
            propCollector.sortAll();
            return;
        }
        IType type = assignment.getType(timestamp);
        if (assignment instanceof Def_Var || assignment instanceof Def_Function) {
            if (type != null && reference.getSubreferences().size() > 1) {
                type = type.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null, false);
            }
            if (type instanceof Referenced_Type) {
                type = type.getTypeRefdLast(timestamp);
            }
            if (type instanceof Component_Type) {
                this.addItemsByType(type, propCollector, prefix, null);
            } else if (type instanceof TTCN3_Set_Seq_Choice_BaseType) {
                this.addItemsByType(type, propCollector, prefix, null);
            } else if (type instanceof Class_Type) {
                Class_Type classType = (Class_Type)type;
                this.addClassProposals(classType, propCollector, replacementOffset, replacementLength, prefix);
            }
        } else if (assignment instanceof Def_Port && type instanceof Port_Type) {
            Port_Type portType = (Port_Type)type;
            this.addPortProposals(propCollector, prefix, portType.getPortBody());
            this.addItemsByType(null, IType.Type_type.TYPE_PORT, propCollector, prefix, null);
        }
    }

    private void addPortProposals(ProposalCollector propCollector, String prefix, PortTypeBody portTypeBody) {
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        PortTypeBody.OperationModes operationMode = portTypeBody.getOperationMode();
        if (PortTypeBody.OperationModes.OP_Message.equals((Object)operationMode) || PortTypeBody.OperationModes.OP_Mixed.equals((Object)operationMode)) {
            DotNotationChainContext.addTemplateProposal("send", "send( ${templateInstance} );", "send( templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("send", "send( ${templateInstance} ) to ${location};", "send( templateInstance ) to location", "", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addReceiveProposals(propCollector, prefix, replacementOffset, replacementLength);
            DotNotationChainContext.addTriggerProposals(propCollector, prefix, replacementOffset, replacementLength);
        }
        if (PortTypeBody.OperationModes.OP_Procedure.equals((Object)operationMode) || PortTypeBody.OperationModes.OP_Mixed.equals((Object)operationMode)) {
            DotNotationChainContext.addTemplateProposal("call", "call( ${templateInstance} );", "call( templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("call", "call( ${templateInstance} , ${callTimer} );", "call( templateInstance , callTimer )", "with timer", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("call", "call( ${templateInstance} ) to ${location};", "call( templateInstance ) to location", "with to clause", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("call", "call( ${templateInstance} , ${callTimer} ) to ${location};", "call( templateInstance , callTimer ) to location", "with timer and to clause", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addGetcallProposals(propCollector, prefix, replacementOffset, replacementLength);
            DotNotationChainContext.addTemplateProposal("reply", "reply( ${templateInstance} );", "reply( templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("reply", "reply( ${templateInstance} ) to ${location};", "reply( templateInstance ) to location", "", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addGetreplyProposals(propCollector, prefix, replacementOffset, replacementLength);
            DotNotationChainContext.addTemplateProposal("raise", "raise( ${signature}, ${templateInstance} );", "raise( signature, templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addTemplateProposal("raise", "raise( ${signature}, ${templateInstance} ) to ${location};", "raise( signature, templateInstance ) to location", "with to clause", propCollector, replacementOffset, replacementLength, prefix);
            DotNotationChainContext.addCatchProposals(propCollector, prefix, replacementOffset, replacementLength);
        }
        DotNotationChainContext.addCheckProposals(propCollector, prefix, replacementOffset, replacementLength);
        DotNotationChainContext.addProposal("clear;", "clear", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addProposal("start;", "start", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addProposal("stop;", "stop", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addProposal("halt;", "halt", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
    }

    public static void addReceiveProposals(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        DotNotationChainContext.addProposal("running", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addProposal("receive", "receive", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive -> value ${myVar};", "receive -> value myVar", "value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive -> sender ${myPeer};", "receive -> sender myPeer", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive -> value ${myVar} sender ${myPeer};", "receive -> value myVar sender myPeer", "value and sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive from ${myPeer};", "receive from myPeer", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive from ${myPeer} -> value ${myVar};", "receive from myPeer -> value myVar", "from clause with value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive( ${template} );", "receive( templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive( ${templateInstance} ) -> value ${myVar};", "receive( templateInstance ) -> value myVar", "value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive( ${templateInstance} ) -> sender ${myPeer};", "receive( templateInstance ) -> sender myPeer", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive( ${templateInstance} ) -> value ${myVar} sender ${myPeer};", "receive( templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive( ${templateInstance} ) from ${myPeer};", "receive( templateInstance ) from myPeer", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("receive", "receive( ${templateInstance} ) from ${myPeer} -> value ${myVar};", "receive( templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector, replacementOffset, replacementLength, prefix);
    }

    public static void addTriggerProposals(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        DotNotationChainContext.addProposal("trigger", "trigger", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger -> value ${myVar};", "trigger -> value myVar", "value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger -> sender ${myPeer};", "trigger -> sender myPeer", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger -> value ${myVar} sender ${myPeer};", "trigger -> value myVar sender myPeer", "value and sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger from ${myPeer};", "trigger from myPeer", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger from ${myPeer} -> value ${myVar};", "trigger from myPeer -> value myVar", "from clause with value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger( ${templateInstance} );", "trigger( templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger( ${templateInstance} ) -> value ${myVar};", "trigger( templateInstance ) -> value myVar", "value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger( ${templateInstance} ) -> sender ${myPeer};", "trigger( templateInstance ) -> sender myPeer", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger( ${templateInstance} ) -> value ${myVar} sender ${myPeer};", "trigger( templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger( ${templateInstance} ) from ${myPeer};", "trigger( templateInstance ) from myPeer", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("trigger", "trigger( ${templateInstance} ) from ${myPeer} -> value ${myVar};", "trigger( templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector, replacementOffset, replacementLength, prefix);
    }

    public static void addGetcallProposals(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        DotNotationChainContext.addProposal("getcall", "getcall", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall from ${myPartner};", "getcall from myPartner", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall -> sender ${myPartnerVar};", "getcall -> sender myPartnerVar", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall( ${templateInstance} );", "getcall( templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall( ${templateInstance} ) from ${myPartner};", "getcall( templateInstance ) from myPartner", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall( ${templateInstance} ) -> sender ${myPartnerVar};", "getcall( templateInstance ) -> sender myPartnerVar", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall( ${templateInstance} ) -> param( ${parameters} );", "getcall( templateInstance ) -> param(parameters)", "parameters", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall( ${templateInstance} ) from ${myPartner} -> param( ${parameters} );", "getcall( templateInstance ) from myPartner -> param(parameters)", "from clause and parameters", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getcall", "getcall( ${templateInstance} ) -> param( ${parameters} ) sender ${mySenderVar};", "getcall( templateInstance ) -> param(parameters) sender mySenderVar", "parameters and sender clause", propCollector, replacementOffset, replacementLength, prefix);
    }

    public static void addGetreplyProposals(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        DotNotationChainContext.addProposal("getreply", "getreply", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getreply", "getreply from ${myPartner};", "getreply from myPartner", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("getreply", "getreply( ${templateInstance} ) -> value ${myReturnValue} param( ${parameters} ) sender ${mySenderVar};", "getreply( templateInstance ) -> value myReturnValue param(parameters) sender mySenderVar", "value, parameters and sender clause", propCollector, replacementOffset, replacementLength, prefix);
    }

    public static void addCatchProposals(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        DotNotationChainContext.addProposal("catch", "catch", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch -> value ${myVar};", "catch -> value myVar", "value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch -> sender ${myPeer};", "catch -> sender myPeer", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch -> value ${myVar} sender ${myPeer};", "catch -> value myVar sender myPeer", "value and sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch from ${myPeer};", "catch from myPeer", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch from ${myPeer} -> value ${myVar};", "catch from myPeer -> value myVar", "from clause with value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( ${signature}, ${templateInstance} );", "catch( signature, templateInstance )", "", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( ${signature}, ${templateInstance} ) -> value ${myVar};", "catch( signature, templateInstance ) -> value myVar", "value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( ${signature}, ${templateInstance} ) -> sender ${myPeer};", "catch( signature, templateInstance ) -> sender myPeer", "sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( ${signature}, ${templateInstance} ) -> value ${myVar} sender ${myPeer};", "catch( signature, templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( ${signature}, ${templateInstance} ) from ${myPeer};", "catch( signature, templateInstance ) from myPeer", "from clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( ${signature}, ${templateInstance} ) from ${myPeer} -> value ${myVar};", "catch( signature, templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("catch", "catch( timeout );", "catch( timeout )", "", propCollector, replacementOffset, replacementLength, prefix);
    }

    public static void addCheckProposals(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        DotNotationChainContext.addProposal("check", "check", IType.Type_type.TYPE_PORT, propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("check", "check( ${portOperation} );", "check( portOperation )", "", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("check", "check( from ${myPeer});", "check( from myPeer)", "form clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("check", "check( from ${myPeer} -> value ${myVar});", "check( from myPeer -> value myVar)", "form and value clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("check", "check( -> value ${myVar} );", "check( -> value myVar)", "value clause", propCollector, replacementOffset, replacementLength, prefix);
        DotNotationChainContext.addTemplateProposal("check", "check( -> value ${myVar} sender ${myPeer} );", "check( -> value myVar sender myPeer)", "value and sender clause", propCollector, replacementOffset, replacementLength, prefix);
    }
}

