/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.designer.editors.configeditor.ConfigItemTransferBase;

public final class IncludeItemTransfer
extends ConfigItemTransferBase {
    private static IncludeItemTransfer instance = new IncludeItemTransfer();
    private static final String TYPE_NAME = "TITAN-IncludeItem-transfer-format";
    private static final int TYPEID = IncludeItemTransfer.registerType((String)"TITAN-IncludeItem-transfer-format");

    public static IncludeItemTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ParseTree[] items = (ParseTree[])object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                out.writeUTF(this.convertToString(items[2 * i]));
                out.writeUTF(this.convertToString(items[2 * i + 1]));
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    protected ParseTree[] nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            ParseTree[] items = new ParseTree[2 * n];
            for (int i = 0; i < n; ++i) {
                String hiddenBefore = in.readUTF();
                String fileName = in.readUTF();
                items[2 * i] = ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore);
                items[2 * i + 1] = new AddedParseTree(fileName);
            }
            return items;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new ParseTree[0];
        }
    }
}

