/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Enumerated_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Enumerated_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Enum2IntExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The operand of the `enum2int' operation should be an enumerated value";
    private final Value value;

    public Enum2IntExpression(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ENUM2INT_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("enum2int(").append(this.value.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType tempType = this.value.getExpressionGovernor(timestamp, expectedValue);
        if (tempType == null) {
            this.value.getLocation().reportSemanticError("Please use a reference to an enumerated value as the first operand of operation `enum2int()'");
            this.setIsErroneous(true);
            return;
        }
        IType last = tempType.getTypeRefdLast(timestamp);
        switch (last.getTypetype()) {
            case TYPE_ASN1_ENUMERATED: 
            case TYPE_TTCN3_ENUMERATED: {
                IValue lastValue = this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                if (IValue.Value_type.OMIT_VALUE.equals((Object)lastValue.getValuetype())) {
                    this.value.getLocation().reportSemanticError("The operand of operation `enum2int' cannot be omit");
                    this.setIsErroneous(true);
                }
                return;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                if (!this.isErroneous) {
                    this.value.getLocation().reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                }
                return;
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last = this.value.getValueRefdLast(timestamp, referenceChain);
        if (last == null || last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        IType type = last.getExpressionGovernor(timestamp, expectedValue);
        type = type.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_ASN1_ENUMERATED: {
                EnumItem item = ((ASN1_Enumerated_Type)type).getEnumItemWithName(((Enumerated_Value)last).getValue());
                this.lastValue = new Integer_Value(((Integer_Value)item.getValue()).getValue());
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case TYPE_TTCN3_ENUMERATED: {
                EnumItem item = ((TTCN3_Enumerated_Type)type).getEnumItemWithName(((Enumerated_Value)last).getValue());
                this.lastValue = new Integer_Value(((Integer_Value)item.getValue()).getValue());
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value.canGenerateSingleExpression();
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        IType governor = this.value.getMyGovernor();
        if (governor == null) {
            governor = this.value.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        if (governor == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for expression `" + this.getFullName() + "''"));
            return;
        }
        String name = governor.getGenNameValue(aData, expression.expression);
        expression.expression.append(name);
        expression.expression.append(".enum2int(");
        this.value.generateCodeExpressionMandatory(aData, expression, false);
        expression.expression.append(")");
    }
}

