/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASN1.Object.Erroneous_FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class FieldSpecifications
extends ASTNode {
    public static final String MISSINGNAMEDFIELDSPECIFICATION = "No field specification with name `{0}''";
    public static final String MISSINGINDEXEDFIELDSPECIFICATION = "No field specification at index `{0}''";
    public static final String DUPLICATEDFIELDSPECIFICATIONFIRST = "Duplicate field specification with name `{0}'' was first declared here";
    public static final String DUPLICATEDFIELDSPECIFICATIONREPEATED = "Duplicate field specification with name `{0}'' was declared here again";
    public static final String DUPLICATED_UNIQUE_FIELD_SPECIFICATION_FIRST = "Duplicate identifier (UNIQUE) field specification with name `{0}'' was first declared here";
    public static final String DUPLICATED_UNIQUE_FIELD_SPECIFICATION_REPEATED = "Duplicate identifier (UNIQUE) field specification with name `{0}'' was declared here again";
    private Map<String, FieldSpecification> fieldSpecificationsMap;
    private final List<FieldSpecification> fieldSpecifications = new ArrayList<FieldSpecification>();
    private Erroneous_FieldSpecification fsError;
    private ObjectClass_Definition myObjectClass;
    private CompilationTimeStamp lastTimeChecked;

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (FieldSpecification fieldSpecification : this.fieldSpecifications) {
            if (fieldSpecification != child) continue;
            return builder.append(".").append(fieldSpecification.getIdentifier().getDisplayName());
        }
        return builder;
    }

    public void setMyObjectClass(ObjectClass_Definition objectClassDefinition) {
        this.myObjectClass = objectClassDefinition;
        for (FieldSpecification fieldSpecification : this.fieldSpecifications) {
            fieldSpecification.setMyObjectClass(objectClassDefinition);
        }
    }

    public void addFieldSpecification(FieldSpecification fieldSpecification) {
        if (null != fieldSpecification && null != fieldSpecification.getIdentifier() && null != fieldSpecification.getIdentifier().getLocation()) {
            this.fieldSpecifications.add(fieldSpecification);
            fieldSpecification.setFullNameParent(this);
            if (null != this.myObjectClass) {
                fieldSpecification.setMyObjectClass(this.myObjectClass);
            }
        }
    }

    public boolean hasFieldSpecificationWithId(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.fieldSpecificationsMap.containsKey(identifier.getName());
    }

    public FieldSpecification getFieldSpecificationByIdentifier(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.fieldSpecificationsMap.containsKey(identifier.getName())) {
            return this.fieldSpecificationsMap.get(identifier.getName());
        }
        identifier.getLocation().reportSemanticError(MessageFormat.format(MISSINGNAMEDFIELDSPECIFICATION, identifier.getDisplayName()));
        return this.getFieldSpecificationError();
    }

    public FieldSpecification getFieldSpecificationByIndex(int index) {
        if (index < this.fieldSpecifications.size()) {
            return this.fieldSpecifications.get(index);
        }
        this.myObjectClass.getLocation().reportSemanticError(MessageFormat.format(MISSINGINDEXEDFIELDSPECIFICATION, index));
        return null;
    }

    public FieldSpecification getFieldSpecificationError() {
        if (null == this.fsError) {
            this.fsError = new Erroneous_FieldSpecification(new Identifier(Identifier.Identifier_type.ID_ASN, "<error>"), true, false);
        }
        return this.fsError;
    }

    public int getNofFieldSpecifications() {
        return this.fieldSpecifications.size();
    }

    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (null == this.fieldSpecificationsMap) {
            this.fieldSpecificationsMap = new HashMap<String, FieldSpecification>(this.fieldSpecifications.size());
        }
        this.lastTimeChecked = timestamp;
        this.fieldSpecificationsMap.clear();
        String hasUnique = null;
        for (FieldSpecification fieldSpecification : this.fieldSpecifications) {
            String name = fieldSpecification.getIdentifier().getName();
            if (this.fieldSpecificationsMap.containsKey(name)) {
                String displayName = fieldSpecification.getIdentifier().getDisplayName();
                Location oldLocation = this.fieldSpecificationsMap.get(name).getIdentifier().getLocation();
                oldLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATEDFIELDSPECIFICATIONFIRST, displayName));
                Location newLocation = fieldSpecification.getIdentifier().getLocation();
                newLocation.reportSemanticError(MessageFormat.format(DUPLICATEDFIELDSPECIFICATIONREPEATED, displayName));
            } else {
                this.fieldSpecificationsMap.put(name, fieldSpecification);
            }
            if (!fieldSpecification.isUnique()) continue;
            if (hasUnique != null) {
                Location oldLocation = this.fieldSpecificationsMap.get(hasUnique).getIdentifier().getLocation();
                oldLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATED_UNIQUE_FIELD_SPECIFICATION_FIRST, hasUnique));
                Location newLocation = fieldSpecification.getIdentifier().getLocation();
                newLocation.reportSemanticError(MessageFormat.format(DUPLICATED_UNIQUE_FIELD_SPECIFICATION_REPEATED, name));
                continue;
            }
            hasUnique = name;
        }
        for (FieldSpecification fieldSpecification : this.fieldSpecifications) {
            fieldSpecification.check(timestamp);
        }
    }

    public List<FieldSpecification> getFieldSpecificationsWithPrefix(String prefix) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        ArrayList<FieldSpecification> results = new ArrayList<FieldSpecification>();
        for (FieldSpecification fieldSpec : this.fieldSpecifications) {
            if (!fieldSpec.getIdentifier().getName().startsWith(prefix)) continue;
            results.add(fieldSpec);
        }
        return results;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.fieldSpecifications != null) {
            for (FieldSpecification fs : this.fieldSpecifications) {
                if (fs.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void generateCode(JavaGenData aData) {
        for (FieldSpecification fs : this.fieldSpecifications) {
            fs.generateCode(aData);
        }
    }

    public boolean hasUnique() {
        return this.getUnique() != null;
    }

    public FieldSpecification getUnique() {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        for (FieldSpecification fs : this.fieldSpecifications) {
            if (!fs.isUnique()) continue;
            return fs;
        }
        return null;
    }
}

