/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ITreeBranch;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;

public final class ExecutorMonitorContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public ITreeLeaf[] getChildren(Object parentElement) {
        if (parentElement instanceof MainControllerElement) {
            BaseExecutor executor = ((MainControllerElement)parentElement).executor();
            List<ITreeLeaf> children = executor.mainControllerRoot().children();
            return children.toArray(new ITreeLeaf[children.size()]);
        }
        if (parentElement instanceof ITreeBranch) {
            List<ITreeLeaf> children = ((ITreeBranch)parentElement).children();
            return children.toArray(new ITreeLeaf[children.size()]);
        }
        return new ITreeBranch[0];
    }

    public ITreeLeaf[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public ITreeBranch getParent(Object element) {
        if (element instanceof ITreeLeaf) {
            return ((ITreeLeaf)element).parent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MainControllerElement) {
            BaseExecutor executor = ((MainControllerElement)element).executor();
            return !executor.mainControllerRoot().children().isEmpty();
        }
        if (element instanceof ITreeBranch) {
            return !((ITreeBranch)element).children().isEmpty();
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

