/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.IDynamicMatch;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanInteger_template
extends Base_Template {
    private TitanInteger single_value;
    private ArrayList<TitanInteger_template> value_list;
    private boolean min_is_present;
    private boolean max_is_present;
    private boolean min_is_exclusive;
    private boolean max_is_exclusive;
    private TitanInteger min_value;
    private TitanInteger max_value;
    private Base_Template.ImplicationMatchStruct<TitanInteger_template> implication;
    private Base_Template.DynamicMatchStruct<TitanInteger> dynamic_match;

    public TitanInteger_template() {
    }

    public TitanInteger_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanInteger_template.check_single_selection(otherValue);
    }

    public TitanInteger_template(int otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanInteger(otherValue);
    }

    public TitanInteger_template(BigInteger otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanInteger(otherValue);
    }

    public TitanInteger_template(TitanInteger otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound integer value.");
        this.single_value = new TitanInteger(otherValue);
    }

    public TitanInteger_template(Optional<TitanInteger> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanInteger(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating an integer template from an unbound optional field.");
            }
        }
    }

    public TitanInteger_template(TitanInteger_template otherValue) {
        this.copy_template(otherValue);
    }

    public TitanInteger_template(TitanInteger_template precondition, TitanInteger_template impliedTemplate) {
        super(Base_Template.template_sel.IMPLICATION_MATCH);
        this.implication = new Base_Template.ImplicationMatchStruct();
        this.implication.precondition = precondition;
        this.implication.implied_template = impliedTemplate;
    }

    public TitanInteger_template(IDynamicMatch<TitanInteger> dynamicMatch) {
        super(Base_Template.template_sel.DYNAMIC_MATCH);
        this.dynamic_match = new Base_Template.DynamicMatchStruct();
        this.dynamic_match.ptr = dynamicMatch;
        this.dynamic_match.ref_count = 1;
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: 
            case CONJUNCTION_MATCH: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
            case VALUE_RANGE: {
                this.min_value = null;
                this.max_value = null;
                break;
            }
            case IMPLICATION_MATCH: {
                if (this.implication != null) {
                    this.implication.precondition = null;
                    this.implication.implied_template = null;
                }
                this.implication = null;
                break;
            }
            case DYNAMIC_MATCH: {
                if (this.dynamic_match == null) break;
                --this.dynamic_match.ref_count;
                if (this.dynamic_match.ref_count != 0) break;
                this.dynamic_match.ptr = null;
                this.dynamic_match = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanInteger_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanInteger) {
            return this.operator_assign((TitanInteger)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to integer", otherValue));
    }

    @Override
    public TitanInteger_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanInteger_template) {
            return this.operator_assign((TitanInteger_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to integer", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanInteger) {
            this.log_match((TitanInteger)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to integer", match_value));
    }

    @Override
    public TitanInteger_template operator_assign(Base_Template.template_sel otherValue) {
        TitanInteger_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanInteger_template operator_assign(int otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanInteger(otherValue);
        return this;
    }

    public TitanInteger_template operator_assign(BigInteger otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanInteger(otherValue);
        return this;
    }

    public TitanInteger_template operator_assign(TitanInteger otherValue) {
        otherValue.must_bound("Assignment of an unbound integer value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanInteger(otherValue);
        return this;
    }

    public TitanInteger_template operator_assign(TitanInteger_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    private void copy_template(TitanInteger_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanInteger(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: 
            case CONJUNCTION_MATCH: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanInteger_template temp = new TitanInteger_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                this.min_is_present = otherValue.min_is_present;
                this.min_is_exclusive = otherValue.min_is_exclusive;
                if (this.min_is_present) {
                    this.min_value = new TitanInteger(otherValue.min_value);
                }
                this.max_is_present = otherValue.max_is_present;
                this.max_is_exclusive = otherValue.max_is_exclusive;
                if (!this.max_is_present) break;
                this.max_value = new TitanInteger(otherValue.max_value);
                break;
            }
            case IMPLICATION_MATCH: {
                this.implication = otherValue.implication;
                break;
            }
            case DYNAMIC_MATCH: {
                this.dynamic_match = otherValue.dynamic_match;
                ++this.dynamic_match.ref_count;
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported integer template.");
            }
        }
        this.set_selection(otherValue);
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanInteger) {
            return this.match((TitanInteger)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to integer", otherValue));
    }

    public boolean match(TitanInteger otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanInteger otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
            case VALUE_RANGE: {
                boolean lowerMatch = true;
                boolean upperMatch = true;
                if (this.min_is_present) {
                    lowerMatch = this.min_is_exclusive ? this.min_value.is_less_than(otherValue) : this.min_value.is_less_than_or_equal(otherValue);
                }
                if (this.max_is_present) {
                    upperMatch = this.max_is_exclusive ? this.max_value.is_greater_than(otherValue) : this.max_value.is_greater_than_or_equal(otherValue);
                }
                return lowerMatch && upperMatch;
            }
            case CONJUNCTION_MATCH: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (this.value_list.get(i).match(otherValue, legacy)) continue;
                    return false;
                }
                return true;
            }
            case IMPLICATION_MATCH: {
                return !((TitanInteger_template)this.implication.precondition).match(otherValue) || ((TitanInteger_template)this.implication.implied_template).match(otherValue);
            }
            case DYNAMIC_MATCH: {
                return this.dynamic_match.ptr.match(otherValue);
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported integer template.");
    }

    @Override
    public TitanInteger valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific integer template.");
        }
        return new TitanInteger(this.single_value);
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        this.clean_up();
        switch (templateType) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: 
            case CONJUNCTION_MATCH: {
                this.set_selection(templateType);
                this.value_list = new ArrayList(listLength);
                for (int i = 0; i < listLength; ++i) {
                    this.value_list.add(new TitanInteger_template());
                }
                break;
            }
            case VALUE_RANGE: {
                this.set_selection(Base_Template.template_sel.VALUE_RANGE);
                this.min_is_present = false;
                this.max_is_present = false;
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            default: {
                throw new TtcnError("Setting an invalid type for an integer template.");
            }
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list integer template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanInteger_template list_item(int listIndex) {
        if (!(Base_Template.template_sel.VALUE_LIST.equals((Object)this.template_selection) || Base_Template.template_sel.COMPLEMENTED_LIST.equals((Object)this.template_selection) || Base_Template.template_sel.CONJUNCTION_MATCH.equals((Object)this.template_selection))) {
            throw new TtcnError("Accessing a list element of a non-list integer template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an integer value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex > this.value_list.size()) {
            throw new TtcnError("Index overflow in an integer value list template.");
        }
        return this.value_list.get(listIndex);
    }

    public void set_min(int otherMinValue) {
        if (!Base_Template.template_sel.VALUE_RANGE.equals((Object)this.template_selection)) {
            throw new TtcnError("Integer template is not range when setting lower limit.");
        }
        if (this.max_is_present && !this.max_value.is_greater_than_or_equal(otherMinValue)) {
            throw new TtcnError("The lower limit of the range is greater than the upper limit in an integer template.");
        }
        this.min_is_present = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanInteger(otherMinValue);
    }

    public void set_min(TitanInteger otherMinValue) {
        otherMinValue.must_bound("Using an unbound value when setting the lower bound in an integer range template.");
        if (!Base_Template.template_sel.VALUE_RANGE.equals((Object)this.template_selection)) {
            throw new TtcnError("Integer template is not range when setting lower limit.");
        }
        if (this.max_is_present && !this.max_value.is_greater_than_or_equal(otherMinValue)) {
            throw new TtcnError("The lower limit of the range is greater than the upper limit in an integer template.");
        }
        this.min_is_present = true;
        this.min_is_exclusive = false;
        this.min_value = otherMinValue;
    }

    public void set_min_exclusive(boolean minExclusive) {
        this.min_is_exclusive = minExclusive;
    }

    public void set_max(int otherMaxValue) {
        if (!Base_Template.template_sel.VALUE_RANGE.equals((Object)this.template_selection)) {
            throw new TtcnError("Integer template is not range when setting upper limit.");
        }
        if (this.min_is_present && this.min_value.is_greater_than(otherMaxValue)) {
            throw new TtcnError("The upper limit of the range is smaller than the lower limit in an integer template.");
        }
        this.max_is_present = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanInteger(otherMaxValue);
    }

    public void set_max(TitanInteger otherMaxValue) {
        otherMaxValue.must_bound("Using an unbound value when setting the upper bound in an integer range template.");
        if (!Base_Template.template_sel.VALUE_RANGE.equals((Object)this.template_selection)) {
            throw new TtcnError("Integer template is not range when setting upper limit.");
        }
        if (this.max_is_present && !this.max_value.is_greater_than(otherMaxValue)) {
            throw new TtcnError("TThe upper limit of the range is smaller than the lower limit in an integer template.");
        }
        this.max_is_present = true;
        this.max_is_exclusive = false;
        this.max_value = otherMaxValue;
    }

    public void set_max_exclusive(boolean maxExclusive) {
        this.max_is_exclusive = maxExclusive;
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case IMPLICATION_MATCH: {
                return !((TitanInteger_template)this.implication.precondition).match_omit() || ((TitanInteger_template)this.implication.implied_template).match_omit();
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                String tmp_str = this.single_value.is_native() ? Integer.toString(this.single_value.get_int()) : this.single_value.get_BigInteger().toString();
                TTCN_Logger.log_event("%s", tmp_str);
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case CONJUNCTION_MATCH: {
                if (Base_Template.template_sel.CONJUNCTION_MATCH.equals((Object)this.template_selection)) {
                    TTCN_Logger.log_event_str("conjunct");
                }
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case VALUE_RANGE: {
                TTCN_Logger.log_char('(');
                if (this.min_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.min_is_present) {
                    if (this.min_value.is_native()) {
                        TTCN_Logger.log_event("%s", Integer.toString(this.min_value.get_int()));
                    } else {
                        TTCN_Logger.log_event("%s", this.min_value.get_BigInteger().toString());
                    }
                } else {
                    TTCN_Logger.log_event_str("-infinity");
                }
                TTCN_Logger.log_event_str(" .. ");
                if (this.max_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.max_is_present) {
                    if (this.max_value.is_native()) {
                        TTCN_Logger.log_event("%s", Integer.toString(this.max_value.get_int()));
                    } else {
                        TTCN_Logger.log_event("%s", this.max_value.get_BigInteger().toString());
                    }
                } else {
                    TTCN_Logger.log_event_str("infinity");
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case IMPLICATION_MATCH: {
                ((TitanInteger_template)this.implication.precondition).log();
                TTCN_Logger.log_event_str(" implies ");
                ((TitanInteger_template)this.implication.implied_template).log();
                break;
            }
            case DYNAMIC_MATCH: {
                TTCN_Logger.log_event_str("@dynamic template");
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    public void log_match(TitanInteger match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                text_buf.push_int(this.single_value);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            case VALUE_RANGE: {
                text_buf.push_int(this.min_is_present ? 1 : 0);
                if (this.min_is_present) {
                    text_buf.push_int(this.min_value);
                }
                text_buf.push_int(this.max_is_present ? 1 : 0);
                if (!this.max_is_present) break;
                text_buf.push_int(this.max_value);
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported integer template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = text_buf.pull_int();
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanInteger_template temp = new TitanInteger_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                boolean bl = this.min_is_present = text_buf.pull_int().get_int() != 0;
                if (this.min_is_present) {
                    this.min_value = text_buf.pull_int();
                }
                boolean bl2 = this.max_is_present = text_buf.pull_int().get_int() != 0;
                if (this.max_is_present) {
                    this.max_value = text_buf.pull_int();
                }
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for an integer template.");
            }
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "integer template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanInteger_template temp = new TitanInteger_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Integer: {
                this.operator_assign(param.get_integer());
                break;
            }
            case MP_IntRange: {
                this.set_type(Base_Template.template_sel.VALUE_RANGE);
                if (param.get_lower_int() != null) {
                    this.set_min(param.get_lower_int());
                }
                this.set_min_exclusive(param.get_is_min_exclusive());
                if (param.get_upper_int() != null) {
                    this.set_max(param.get_upper_int());
                }
                this.set_max_exclusive(param.get_is_max_exclusive());
                break;
            }
            case MP_Expression: {
                switch (param.get_expr_type()) {
                    case EXPR_NEGATE: {
                        TitanInteger operand = new TitanInteger();
                        operand.set_param(param.get_operand1());
                        this.operator_assign(operand.sub());
                        break block0;
                    }
                    case EXPR_ADD: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.add(operand2));
                        break block0;
                    }
                    case EXPR_SUBTRACT: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.sub(operand2));
                        break block0;
                    }
                    case EXPR_MULTIPLY: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.mul(operand2));
                        break block0;
                    }
                    case EXPR_DIVIDE: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        if (operand2.operator_equals(0)) {
                            param.error("Integer division by zero.", new Object[0]);
                        }
                        this.operator_assign(operand1.div(operand2));
                        break block0;
                    }
                }
                param.expr_type_error("an integer");
                break;
            }
            default: {
                param.type_error("integer template");
            }
        }
        this.is_ifPresent = param.get_ifpresent() || param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = new Param_Types.Module_Param_Integer(this.single_value);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            case VALUE_RANGE: {
                TitanInteger lower_bound = this.min_is_present ? this.min_value : null;
                TitanInteger upper_bound = this.max_is_present ? this.max_value : null;
                mp = new Param_Types.Module_Param_IntRange(lower_bound, upper_bound, this.min_is_exclusive, this.max_is_exclusive);
                break;
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported integer template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanInteger_template.get_res_name(restriction), name == null ? "integer" : name));
    }
}

