/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class Base64Decoder {
    private static final byte[] ENCODING_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte padding = (byte)61;
    private static final byte[] DECODING_TABLE = new byte[128];

    private Base64Decoder() {
    }

    public static byte[] decode(byte[] data) {
        int len = data.length / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            Base64Decoder.decode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while decoding", (Throwable)e);
        }
        return bOut.toByteArray();
    }

    private static boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    public static int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int end;
        int outLen = 0;
        for (end = off + length; end > off && Base64Decoder.ignore((char)data[end - 1]); --end) {
        }
        int i = off;
        int finish = end - 4;
        i = Base64Decoder.nextI(data, i, finish);
        while (i < finish) {
            byte b1 = DECODING_TABLE[data[i++]];
            i = Base64Decoder.nextI(data, i, finish);
            byte b2 = DECODING_TABLE[data[i++]];
            i = Base64Decoder.nextI(data, i, finish);
            byte b3 = DECODING_TABLE[data[i++]];
            i = Base64Decoder.nextI(data, i, finish);
            byte b4 = DECODING_TABLE[data[i++]];
            out.write(b1 << 2 | b2 >> 4);
            out.write(b2 << 4 | b3 >> 2);
            out.write(b3 << 6 | b4);
            outLen += 3;
            i = Base64Decoder.nextI(data, i, finish);
        }
        return outLen += Base64Decoder.decodeLastBlock(out, (char)data[end - 4], (char)data[end - 3], (char)data[end - 2], (char)data[end - 1]);
    }

    private static int nextI(byte[] data, int i, int finish) {
        int i2;
        for (i2 = i; i2 < finish && Base64Decoder.ignore((char)data[i2]); ++i2) {
        }
        return i2;
    }

    private static int decodeLastBlock(OutputStream out, char c1, char c2, char c3, char c4) throws IOException {
        if (c3 == padding) {
            byte b1 = DECODING_TABLE[c1];
            byte b2 = DECODING_TABLE[c2];
            out.write(b1 << 2 | b2 >> 4);
            return 1;
        }
        if (c4 == padding) {
            byte b1 = DECODING_TABLE[c1];
            byte b2 = DECODING_TABLE[c2];
            byte b3 = DECODING_TABLE[c3];
            out.write(b1 << 2 | b2 >> 4);
            out.write(b2 << 4 | b3 >> 2);
            return 2;
        }
        byte b1 = DECODING_TABLE[c1];
        byte b2 = DECODING_TABLE[c2];
        byte b3 = DECODING_TABLE[c3];
        byte b4 = DECODING_TABLE[c4];
        out.write(b1 << 2 | b2 >> 4);
        out.write(b2 << 4 | b3 >> 2);
        out.write(b3 << 6 | b4);
        return 3;
    }

    static {
        for (int i = 0; i < ENCODING_TABLE.length; ++i) {
            Base64Decoder.DECODING_TABLE[Base64Decoder.ENCODING_TABLE[i]] = (byte)i;
        }
    }
}

