/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IASTNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.CharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.UniversalCharstring_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Range_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Single_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class PatternString
implements IVisitableNode,
INamedNode,
IASTNode {
    private PatternType patterntype;
    private String content;
    protected Scope myScope;
    private INamedNode nameParent;
    private boolean nocase = false;
    private Location location = null;
    private final List<ps_elem_t> elems = new ArrayList<ps_elem_t>();

    public PatternString() {
        this.patterntype = PatternType.CHARSTRING_PATTERN;
    }

    public PatternString(PatternType pt) {
        this.patterntype = pt;
    }

    public ps_elem_t get_last_elem() {
        if (this.elems.isEmpty()) {
            return null;
        }
        ps_elem_t last_elem = this.elems.get(this.elems.size() - 1);
        if (last_elem.kind == ps_elem_t.kind_t.PSE_STR) {
            return last_elem;
        }
        return null;
    }

    public void addChar(char c) {
        ps_elem_t last_elem = this.get_last_elem();
        if (last_elem != null) {
            last_elem.str = last_elem.str + String.valueOf(c);
        } else {
            this.elems.add(new ps_elem_t(ps_elem_t.kind_t.PSE_STR, String.valueOf(c)));
        }
    }

    public void addString(String p_str) {
        ps_elem_t last_elem = this.get_last_elem();
        if (last_elem != null) {
            last_elem.str = last_elem.str + p_str;
        } else {
            this.elems.add(new ps_elem_t(ps_elem_t.kind_t.PSE_STR, p_str));
        }
    }

    public void addStringUSI(List<String> usi_str) {
        UniversalCharstring s = new UniversalCharstring(usi_str, this.location);
        ps_elem_t last_elem = this.get_last_elem();
        if (last_elem != null) {
            last_elem.str = last_elem.str.concat(s.getStringRepresentationForPattern());
        } else {
            this.elems.add(new ps_elem_t(ps_elem_t.kind_t.PSE_STR, s.getStringRepresentationForPattern()));
        }
    }

    public void addRef(Reference p_ref, boolean N) {
        this.elems.add(new ps_elem_t(ps_elem_t.kind_t.PSE_REF, p_ref, N));
    }

    public PatternType getPatterntype() {
        return this.patterntype;
    }

    public void setPatterntype(PatternType pt) {
        this.patterntype = pt;
    }

    public void setContent(String s) {
        this.content = s;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getContent() {
        return this.content;
    }

    public String getFullString() {
        return this.content;
    }

    @Override
    public String getFullName() {
        return this.getFullName(this).toString();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        if (null != this.nameParent) {
            return this.nameParent.getFullName(this);
        }
        return new StringBuilder();
    }

    @Override
    public final void setFullNameParent(INamedNode nameParent) {
        this.nameParent = nameParent;
    }

    @Override
    public INamedNode getNameParent() {
        return this.nameParent;
    }

    @Override
    public void setMyScope(Scope scope) {
        this.myScope = scope;
        for (int i = 0; i < this.elems.size(); ++i) {
            this.elems.get(i).setScope(scope);
        }
    }

    @Override
    public final Scope getMyScope() {
        return this.myScope;
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (int i = 0; i < this.elems.size(); ++i) {
            this.elems.get(i).setCodeSection(codeSection);
        }
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return v.leave(this) != 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String create_charstring_literals(JavaGenData aData, Module module, StringBuilder preamble) {
        aData.addBuiltinTypeImport("TitanCharString");
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        StringBuilder s = new StringBuilder();
        this.check_refs(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, CompilationTimeStamp.getBaseTimestamp());
        if (this.patterntype == PatternType.CHARSTRING_PATTERN) {
            aData.addBuiltinTypeImport("TitanCharString_template");
            s.append("TitanCharString_template(template_sel.STRING_PATTERN, new TitanCharString(");
        } else {
            aData.addBuiltinTypeImport("TitanUniversalCharString_template");
            s.append("TitanUniversalCharString_template(template_sel.STRING_PATTERN, new TitanCharString(");
        }
        if (this.elems.isEmpty()) {
            if (this.content == null || this.content.isEmpty()) {
                s.append("\"\"");
            } else {
                this.addString(this.content);
            }
        }
        block22: for (int i = 0; i < this.elems.size(); ++i) {
            ps_elem_t pse;
            if (i > 0) {
                s.append(".operator_concatenate(");
            }
            if ((pse = this.elems.get(i)).is_charstring) {
                if (i == 0) {
                    s.append("new TitanCharString(\"?\")");
                    continue;
                }
                if (i + 1 > this.elems.size()) {
                    s.append("\"?\"");
                    continue;
                }
                if (i + 1 >= this.elems.size()) continue;
                s.append("\"?\")");
                continue;
            }
            if (pse.is_universal_charstring) {
                if (i == 0) {
                    s.append("new TitanCharString(\"?\")");
                    continue;
                }
                if (i + 1 > this.elems.size()) {
                    s.append("\"?\"");
                    continue;
                }
                if (i + 1 >= this.elems.size()) continue;
                s.append("\"?\")");
                continue;
            }
            switch (pse.kind) {
                case PSE_STR: {
                    s.append("new TitanCharString(\"");
                    s.append(pse.str);
                    s.append("\")");
                    break;
                }
                case PSE_REFDSET: {
                    if (pse.t == null) {
                        ErrorReporter.INTERNAL_ERROR((String)"PatternString.create_charstring_literals()");
                        break;
                    }
                    if (pse.t.getSubtype() == null) {
                        if (i == 0) {
                            s.append("new TitanCharString(\"?\")");
                            continue block22;
                        }
                        if (i + 1 > this.elems.size()) {
                            s.append("\"?\"");
                            continue block22;
                        }
                        if (i + 1 >= this.elems.size()) continue block22;
                        s.append("\"?\")");
                        continue block22;
                    }
                    List<ParsedSubType> vec = pse.t.getSubtype().getSubtypeParsed();
                    while (vec == null) {
                        Reference tmp_ref = null;
                        if (pse.t instanceof Referenced_Type) {
                            tmp_ref = ((Referenced_Type)pse.t).getReference();
                        }
                        if (tmp_ref == null) break;
                        pse.t = (Type)tmp_ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false).getType(CompilationTimeStamp.getBaseTimestamp());
                        if (pse.t.getSubtype() == null) break;
                        vec = pse.t.getSubtype().getSubtypeParsed();
                    }
                    s.append('\"');
                    if (vec.size() > 1) {
                        s.append('(');
                    }
                    for (int j = 0; j < vec.size(); ++j) {
                        ParsedSubType pst = vec.get(j);
                        if (j > 0) {
                            s.append("|\"+");
                        } else {
                            s.append("\"+");
                        }
                        block5 : switch (pst.getSubTypetype()) {
                            case RANGE_PARSEDSUBTYPE: {
                                if (!(pst instanceof Range_ParsedSubType)) break;
                                Range_ParsedSubType range = (Range_ParsedSubType)pst;
                                s.append("\"[\" + ");
                                switch (range.getMin().getValuetype()) {
                                    case CHARSTRING_VALUE: {
                                        s.append('\"');
                                        s.append(((Charstring_Value)range.getMin()).getValue());
                                        s.append('\"');
                                        s.append("+ \"-\" +");
                                        s.append('\"');
                                        s.append(((Charstring_Value)range.getMax()).getValue());
                                        s.append('\"');
                                        break;
                                    }
                                    case UNIVERSALCHARSTRING_VALUE: {
                                        s.append('\"');
                                        s.append(((UniversalCharstring_Value)range.getMin()).getValue().getStringRepresentationForPattern());
                                        s.append('\"');
                                        s.append("+ \"-\" +");
                                        s.append('\"');
                                        s.append(((UniversalCharstring_Value)range.getMax()).getValue().getStringRepresentationForPattern());
                                        s.append('\"');
                                        break;
                                    }
                                    default: {
                                        ErrorReporter.INTERNAL_ERROR((String)"PatternString.create_charstring_literals()");
                                    }
                                }
                                s.append(" + \"]\"");
                                break;
                            }
                            case SINGLE_PARSEDSUBTYPE: {
                                if (!(pst instanceof Single_ParsedSubType)) break;
                                Single_ParsedSubType single = (Single_ParsedSubType)pst;
                                switch (single.getValue().getValuetype()) {
                                    case CHARSTRING_VALUE: {
                                        s.append('\"');
                                        s.append(((Charstring_Value)single.getValue()).getValue());
                                        s.append('\"');
                                        break block5;
                                    }
                                    case UNIVERSALCHARSTRING_VALUE: {
                                        s.append('\"');
                                        s.append(((UniversalCharstring_Value)single.getValue()).getValue().getStringRepresentationForPattern());
                                        s.append('\"');
                                        break block5;
                                    }
                                }
                                ErrorReporter.INTERNAL_ERROR((String)"PatternString.create_charstring_literals()");
                                break;
                            }
                            default: {
                                ErrorReporter.INTERNAL_ERROR((String)"PatternString.create_charstring_literals()");
                            }
                        }
                        s.append("+\"");
                    }
                    if (vec.size() > 1) {
                        s.append(')');
                    }
                    s.append('\"');
                    break;
                }
                case PSE_REF: {
                    Assignment assign = pse.ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                    ExpressionStruct expr = new ExpressionStruct();
                    pse.ref.generateConstRef(aData, expr);
                    Value.generateCodeExpressionOptionalFieldReference(aData, expr, pse.ref);
                    s.append((CharSequence)expr.expression);
                    String str = "";
                    if (pse.with_N && assign != null) {
                        if (assign.getAssignmentType() == Assignment.Assignment_type.A_TEMPLATE || assign.getAssignmentType() == Assignment.Assignment_type.A_MODULEPAR_TEMPLATE || assign.getAssignmentType() == Assignment.Assignment_type.A_VAR_TEMPLATE || assign.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_IN || assign.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_OUT || assign.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_INOUT) {
                            str = String.format("if (%s.get_istemplate_kind(\"value\") == false) {\nthrow new TtcnError(\"Only specific value template allowed in pattern reference with \\\\N{ref}\");\n}\n", expr.expression.toString());
                        }
                        preamble.append(str);
                        preamble.append(String.format("if (%s.lengthof().operator_not_equals(1))\n{\nthrow new TtcnError(\"The length of the %scharstring must be of length one, when it is being referenced in a pattern with \\\\N{ref}\");\n}\n", expr.expression.toString(), assign.getType(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_UCHARSTRING ? "universal " : ""));
                    }
                    if (assign != null) {
                        switch (assign.getAssignmentType()) {
                            case A_TEMPLATE: 
                            case A_MODULEPAR_TEMPLATE: 
                            case A_VAR_TEMPLATE: 
                            case A_PAR_TEMP_IN: 
                            case A_PAR_TEMP_OUT: 
                            case A_PAR_TEMP_INOUT: {
                                if (!(assign.getType(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_CHARSTRING && assign.getType(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING || pse.with_N)) {
                                    s.append(".get_single_value()");
                                    break;
                                }
                                if (assign.getType(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_UCHARSTRING && pse.with_N) {
                                    s.append(".valueof().get_stringRepr_for_pattern()");
                                    break;
                                }
                                s.append(".valueof()");
                                break;
                            }
                            case A_MODULEPAR: 
                            case A_VAR: 
                            case A_PAR_VAL: 
                            case A_PAR_VAL_IN: 
                            case A_PAR_VAL_OUT: 
                            case A_PAR_VAL_INOUT: {
                                if (assign.getType(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING) break;
                                s.append(".get_stringRepr_for_pattern()");
                                break;
                            }
                            case A_CONST: 
                            case A_EXT_CONST: {
                                if (assign.getType(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING) break;
                                s.append(".get_stringRepr_for_pattern()");
                                break;
                            }
                        }
                    }
                    expr = null;
                }
            }
            if (i <= 0) continue;
            s.append(')');
        }
        s.append(") ,");
        s.append(this.nocase ? "true" : "false");
        s.append(')');
        return s.toString();
    }

    public Value get_value() {
        if (this.content == null) {
            return null;
        }
        return new Charstring_Value(this.content);
    }

    public void set_nocase(boolean p_nocase) {
        this.nocase = p_nocase;
    }

    public boolean get_nocase() {
        return this.nocase;
    }

    public void check_refs(Expected_Value_type expected_value, CompilationTimeStamp timestamp) {
        block5: for (int i = 0; i < this.elems.size(); ++i) {
            ps_elem_t pse = this.elems.get(i);
            switch (pse.kind) {
                case PSE_STR: {
                    continue block5;
                }
                case PSE_REFDSET: {
                    continue block5;
                }
                case PSE_REF: {
                    pse.checkRef(this.patterntype, expected_value, timestamp);
                }
            }
        }
    }

    public boolean has_refs() {
        for (int i = 0; i < this.elems.size(); ++i) {
            switch (this.elems.get(i).kind) {
                case PSE_REFDSET: 
                case PSE_REF: {
                    return true;
                }
            }
        }
        return false;
    }

    public void check_pattern() {
        for (int i = 0; i < this.elems.size(); ++i) {
            ps_elem_t pse = this.elems.get(i);
            if (pse.kind == ps_elem_t.kind_t.PSE_STR) continue;
            ErrorReporter.INTERNAL_ERROR((String)"PatternString.check_pattern()");
        }
        switch (this.patterntype) {
            case CHARSTRING_PATTERN: {
                break;
            }
        }
    }

    public static class ps_elem_t {
        private kind_t kind;
        private String str;
        private Reference ref;
        private Type t;
        private final boolean with_N;
        private boolean is_charstring;
        private boolean is_universal_charstring;

        public ps_elem_t(kind_t p_kind, String p_str) {
            this.kind = p_kind;
            this.str = p_str;
            this.ref = null;
            this.t = null;
            this.with_N = false;
            this.is_charstring = false;
            this.is_universal_charstring = false;
        }

        public ps_elem_t(kind_t p_kind, Reference p_ref, boolean N) {
            this.kind = p_kind;
            this.str = null;
            this.with_N = N;
            this.is_charstring = false;
            this.is_universal_charstring = false;
            if (p_ref == null) {
                ErrorReporter.INTERNAL_ERROR((String)"PatternString.ps_elem_t.ps_elem_t()");
            } else {
                this.ref = p_ref;
            }
        }

        public ps_elem_t(ps_elem_t p) {
            this.kind = p.kind;
            this.str = null;
            this.ref = null;
            this.t = null;
            this.with_N = false;
            this.is_charstring = false;
            this.is_universal_charstring = false;
            switch (this.kind) {
                case PSE_STR: {
                    this.str = p.str;
                    break;
                }
                case PSE_REF: {
                    this.ref = p.ref;
                    break;
                }
                case PSE_REFDSET: {
                    ErrorReporter.INTERNAL_ERROR((String)"PatternString.ps_elem_t.ps_elem_t");
                }
            }
        }

        public void clean_up() {
            switch (this.kind) {
                case PSE_STR: {
                    this.str = null;
                }
                case PSE_REFDSET: 
                case PSE_REF: {
                    this.ref = null;
                    break;
                }
            }
        }

        public void setFullName(INamedNode parent_name) {
            switch (this.kind) {
                case PSE_REFDSET: 
                case PSE_REF: {
                    this.ref.setFullNameParent(parent_name);
                    break;
                }
            }
        }

        public void setScope(Scope p_scope) {
            switch (this.kind) {
                case PSE_REFDSET: 
                case PSE_REF: {
                    this.ref.setMyScope(p_scope);
                    break;
                }
            }
        }

        public void checkRef(PatternType pstr_type, Expected_Value_type expected_value, CompilationTimeStamp timestamp) {
            IType.Type_type tt;
            if (this.kind != kind_t.PSE_REF) {
                ErrorReporter.INTERNAL_ERROR((String)"PatternString.ps_elem_t.chk_ref()");
                return;
            }
            Referenced_Value v = null;
            IValue v_last = null;
            if (this.ref.getDisplayName().equals("charstring")) {
                this.is_charstring = true;
                return;
            }
            if (this.ref.getDisplayName().equals("universal charstring")) {
                this.is_universal_charstring = true;
                return;
            }
            Assignment ass = this.ref.getRefdAssignment(timestamp, false);
            if (ass == null) {
                return;
            }
            IType ref_type = ass.getType(timestamp).getTypeRefdLast(timestamp).getFieldType(timestamp, this.ref, 1, expected_value, null, false);
            switch (pstr_type) {
                case CHARSTRING_PATTERN: {
                    tt = IType.Type_type.TYPE_CHARSTRING;
                    if (ref_type.getTypetype() == IType.Type_type.TYPE_CHARSTRING) break;
                    this.ref.getLocation().reportSemanticError("Type of the referenced " + ass.getAssignmentName() + " '" + this.ref.getDisplayName() + "' should be 'charstring'");
                    break;
                }
                case UNIVCHARSTRING_PATTERN: {
                    tt = ref_type.getTypetype();
                    if (tt == IType.Type_type.TYPE_CHARSTRING || tt == IType.Type_type.TYPE_UCHARSTRING) break;
                    this.ref.getLocation().reportSemanticError("Type of the referenced " + ass.getAssignmentName() + " '" + this.ref.getDisplayName() + "' should be either 'charstring' or 'universal charstring'");
                    break;
                }
                default: {
                    this.ref.getLocation().reportSemanticError("Unknown pattern string type");
                    return;
                }
            }
            Type refcheckertype = null;
            if (tt == IType.Type_type.TYPE_CHARSTRING) {
                refcheckertype = new CharString_Type();
            } else if (tt == IType.Type_type.TYPE_UCHARSTRING) {
                refcheckertype = new UniversalCharstring_Type();
            }
            block4 : switch (ass.getAssignmentType()) {
                case A_TYPE: {
                    this.kind = kind_t.PSE_REFDSET;
                    this.t = (Type)ass.getType(timestamp);
                    break;
                }
                case A_MODULEPAR_TEMPLATE: 
                case A_VAR_TEMPLATE: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    break;
                }
                case A_TEMPLATE: {
                    ITTCN3Template templ = null;
                    templ = ((Def_Template)ass).getTemplate(timestamp);
                    refcheckertype.checkThisTemplateRef(timestamp, templ);
                    switch (templ.getTemplatetype()) {
                        case SPECIFIC_VALUE: {
                            v_last = templ.getValue();
                            break;
                        }
                        case CSTR_PATTERN: {
                            if (!this.with_N) {
                                PatternString ps = ((CharString_Pattern_Template)templ).getPatternstring();
                                if (ps.has_refs()) break block4;
                                v_last = ps.get_value();
                                break;
                            }
                        }
                        default: {
                            this.ref.getLocation().reportSemanticError("Unable to resolve referenced '" + this.ref.getDisplayName() + "' to character string type. '" + templ.getTemplateTypeName() + "' template cannot be used.");
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Reference t_ref = this.ref;
                    t_ref.setLocation(this.ref.getLocation());
                    v = new Referenced_Value(t_ref);
                    v.setMyGovernor(refcheckertype);
                    v.setMyScope(this.ref.getMyScope());
                    v.setLocation(this.ref.getLocation());
                    refcheckertype.checkThisValue(timestamp, v, null, new IType.ValueCheckingOptions(expected_value, false, false, true, false, false));
                }
            }
            if (v_last != null && (v_last.getValuetype() == IValue.Value_type.CHARSTRING_VALUE || v_last.getValuetype() == IValue.Value_type.UNIVERSALCHARSTRING_VALUE)) {
                if (v_last.getValuetype() == IValue.Value_type.CHARSTRING_VALUE) {
                    if (this.with_N && ((Charstring_Value)v_last).getValue().length() != 1) {
                        this.ref.getLocation().reportSemanticError("The length of the charstring must be of length one, when it is being referenced in a pattern with \\N{ref}");
                    }
                    this.str = ((Charstring_Value)v_last).getValue();
                } else {
                    if (this.with_N && ((UniversalCharstring_Value)v_last).getValue().length() != 1) {
                        this.ref.getLocation().reportSemanticError("The length of the universal charstring must be of length one, when it is being referenced in a pattern with \\N{ref}");
                    }
                    this.str = ((UniversalCharstring_Value)v_last).getValue().getStringRepresentationForPattern();
                }
                this.kind = kind_t.PSE_STR;
            }
            v = null;
        }

        public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
            switch (this.kind) {
                case PSE_REFDSET: 
                case PSE_REF: {
                    this.ref.setCodeSection(codeSection);
                    break;
                }
            }
        }

        public String toString() {
            switch (this.kind) {
                case PSE_STR: {
                    return this.str;
                }
                case PSE_REFDSET: 
                case PSE_REF: {
                    return this.ref.getDisplayName();
                }
            }
            return "null";
        }

        public static enum kind_t {
            PSE_STR,
            PSE_REF,
            PSE_REFDSET;

        }
    }

    public static enum PatternType {
        CHARSTRING_PATTERN,
        UNIVCHARSTRING_PATTERN;

    }
}

