/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectUnionCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectUnionCases
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".select_union_case_";
    private final List<SelectUnionCase> selectUnionCases = new ArrayList<SelectUnionCase>();

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.selectUnionCases.size();
        for (int i = 0; i < size; ++i) {
            if (this.selectUnionCases.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    public int getSize() {
        return this.selectUnionCases.size();
    }

    public SelectUnionCase getSelectUnionCase(int index) {
        if (index < this.selectUnionCases.size()) {
            return this.selectUnionCases.get(index);
        }
        return null;
    }

    public void addSelectUnionCase(SelectUnionCase selectUnionCase) {
        this.selectUnionCases.add(selectUnionCase);
        selectUnionCase.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.setCodeSection(codeSection);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        int size = this.selectUnionCases.size();
        for (int i = 0; i < size; ++i) {
            this.selectUnionCases.get(i).setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.setMyAltguards(altGuards);
        }
    }

    public void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.getStatementBlock().setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type result = StatementBlock.ReturnStatus_type.RS_MAYBE;
        boolean hasElse = false;
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            switch (selectCase.hasReturn(timestamp)) {
                case RS_NO: {
                    if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_NO;
                    break;
                }
                case RS_YES: {
                    if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_YES;
                    break;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
            if (!selectCase.hasElse()) continue;
            hasElse = true;
            break;
        }
        if (!hasElse && result == StatementBlock.ReturnStatus_type.RS_YES) {
            return StatementBlock.ReturnStatus_type.RS_MAYBE;
        }
        return result;
    }

    public boolean hasReceivingStatement() {
        for (int i = 0; i < this.selectUnionCases.size(); ++i) {
            if (!this.selectUnionCases.get(i).hasReceivingStatement()) continue;
            return true;
        }
        return false;
    }

    public void check(CompilationTimeStamp aTimestamp, TTCN3_Choice_Type aUnionType, List<String> aFieldNames) {
        boolean unreachable = false;
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            unreachable = selectCase.check(aTimestamp, aUnionType, unreachable, aFieldNames);
        }
    }

    public void check(CompilationTimeStamp aTimestamp, ASN1_Choice_Type aChoiceType, List<String> aFieldNames) {
        boolean unreachable = false;
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            unreachable = selectCase.check(aTimestamp, aChoiceType, unreachable, aFieldNames);
        }
    }

    public void check(CompilationTimeStamp aTimestamp, Anytype_Type aAnytypeType, List<String> aTypesCovered) {
        boolean unreachable = false;
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            unreachable = selectCase.check(aTimestamp, aAnytypeType, unreachable, aTypesCovered);
        }
    }

    public void checkAllowedInterleave() {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (SelectUnionCase selectCase : this.selectUnionCases) {
            selectCase.updateSyntax(reparser, false);
            reparser.updateLocation(selectCase.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.selectUnionCases == null) {
            return;
        }
        for (SelectUnionCase sc : this.selectUnionCases) {
            sc.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.selectUnionCases != null) {
            for (SelectUnionCase sc : this.selectUnionCases) {
                if (sc.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public List<SelectUnionCase> getSelectUnionCaseArray() {
        return this.selectUnionCases;
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        source.append("case UNBOUND_VALUE :\n");
        source.append("throw new TtcnError(\"The union in the head shall be initialized\");\n");
        AtomicBoolean unreach = new AtomicBoolean(false);
        for (int i = 0; i < this.selectUnionCases.size(); ++i) {
            this.selectUnionCases.get(i).generateCode(aData, source, unreach);
            if (unreach.get()) break;
        }
        if (!unreach.get()) {
            source.append("default:\nbreak;\n");
        }
    }
}

