/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.utils;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class SelectionUtils {
    private SelectionUtils() {
    }

    public static boolean isSelectionALogFile(ISelection selection) {
        IFile logFile = SelectionUtils.selectionToIFile(selection);
        return logFile != null && SelectionUtils.hasLogFileExtension(logFile);
    }

    public static IFile selectionToIFile(ISelection selection) {
        List iFiles = org.eclipse.titan.common.utils.SelectionUtils.filterSelection((ISelection)selection, IFile.class);
        if (iFiles.size() != 1) {
            return null;
        }
        return (IFile)iFiles.get(0);
    }

    public static boolean isSelectionALogViewerProject(ISelection selection) {
        List iProjects = org.eclipse.titan.common.utils.SelectionUtils.filterSelection((ISelection)selection, IProject.class);
        if (iProjects.size() != 1) {
            return false;
        }
        IProject project = (IProject)iProjects.get(0);
        try {
            if (project.getNature("org.eclipse.titan.log.viewer.TitanLogProject") == null) {
                return false;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    public static boolean isSelectionAnUnlinkedFolder(ISelection selection) {
        List iFolders = org.eclipse.titan.common.utils.SelectionUtils.filterSelection((ISelection)selection, IFolder.class);
        if (iFolders.size() != 1) {
            return false;
        }
        IFolder folder = (IFolder)iFolders.get(0);
        if (folder.isLinked()) {
            return false;
        }
        IContainer parentResource = folder.getParent();
        while (parentResource.getType() != 4) {
            IFolder parentFolder;
            if (parentResource instanceof IFolder && (parentFolder = (IFolder)parentResource).isLinked()) {
                return false;
            }
            parentResource = parentResource.getParent();
        }
        return true;
    }

    public static boolean hasSelectionClosedProjects(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        for (IProject project : ss) {
            if (project.isOpen()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSelectionOpenedProjects(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        for (IProject project : ss) {
            if (!project.isOpen()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLogFileExtension(IFile logFile) {
        String fileExtension = logFile.getFileExtension();
        return "log".equals(fileExtension);
    }
}

