/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.net.InetAddress;
import java.text.MessageFormat;

public final class CommentUtils {
    private static final String HEADER_COMMENT_TEXT = "{0}This file was generated by the TITAN Designer Eclipse plug-in version {1}\n{0}for ({2}@{3})";
    public static final String COPYRIGHT_TEXT = "Copyright (c) 2000-2024 Ericsson Telecom AB";
    public static final String DO_NOT_EDIT_TEXT = "Do not edit this file unless you know what you are doing!";
    public static final String ECLIPSE_LICENSE_TEXT = "{0}All rights reserved. This program and the accompanying materials\n{0}are made available under the terms of the Eclipse Public License v2.0\n{0}which accompanies this distribution, and is available at\n{0}https://www.eclipse.org/org/documents/epl-2.0/EPL-2.0.html\n";

    public static String getHeaderComments(char commentChar, String versionString) {
        return CommentUtils.getHeaderComments(String.valueOf(commentChar) + " ", versionString);
    }

    public static String getHeaderComments(String commentString, String versionString) {
        String hostName;
        String userName;
        try {
            userName = System.getProperty("user.name");
        }
        catch (Exception e) {
            userName = "unknown";
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostName = "unknown";
        }
        return MessageFormat.format(HEADER_COMMENT_TEXT, commentString, versionString, userName, hostName);
    }

    public static String getHeaderCommentsWithCopyright(String commentString, String versionString) {
        return CommentUtils.getHeaderComments(commentString, versionString) + "\n" + commentString + COPYRIGHT_TEXT + "\n\n";
    }

    public static String getHeaderCommentsWithCopyrightAndDoNotEdit(String commentString, String versionString) {
        return CommentUtils.getHeaderCommentsWithCopyright(commentString, versionString) + "\n" + commentString + DO_NOT_EDIT_TEXT + "\n";
    }

    public static String getHeaderCommentsWithCopyrightAndLicenseAndDoNotEdit(String commentString, String versionString) {
        return CommentUtils.getHeaderCommentsWithCopyright(commentString, versionString) + CommentUtils.getLicenseComment(commentString) + "\n" + commentString + DO_NOT_EDIT_TEXT + "\n\n";
    }

    public static String getLicenseComment(String commentString) {
        return MessageFormat.format(ECLIPSE_LICENSE_TEXT, commentString);
    }
}

