/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.IDynamicMatch;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public abstract class Base_Template {
    protected template_sel template_selection;
    protected boolean is_ifPresent;

    protected Base_Template() {
        this.template_selection = template_sel.UNINITIALIZED_TEMPLATE;
        this.is_ifPresent = false;
    }

    protected Base_Template(template_sel otherValue) {
        this.template_selection = otherValue;
        this.is_ifPresent = false;
    }

    protected void set_selection(template_sel otherValue) {
        this.template_selection = otherValue;
        this.is_ifPresent = false;
    }

    protected void set_selection(Base_Template otherValue) {
        this.template_selection = otherValue.template_selection;
        this.is_ifPresent = otherValue.is_ifPresent;
    }

    public template_sel get_selection() {
        return this.template_selection;
    }

    public void set_ifPresent() {
        this.is_ifPresent = true;
    }

    public boolean is_bound() {
        return this.template_selection != template_sel.UNINITIALIZED_TEMPLATE;
    }

    public boolean is_value() {
        return !this.is_ifPresent && this.template_selection == template_sel.SPECIFIC_VALUE;
    }

    public void clean_up() {
        this.template_selection = template_sel.UNINITIALIZED_TEMPLATE;
    }

    protected static void check_single_selection(template_sel otherValue) {
        switch (otherValue) {
            case ANY_VALUE: 
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            default: {
                throw new TtcnError("Initialization of a template with an invalid selection.");
            }
        }
    }

    protected static String get_res_name(template_res tr) {
        switch (tr) {
            case TR_VALUE: {
                return "value";
            }
            case TR_OMIT: {
                return "omit";
            }
            case TR_PRESENT: {
                return "present";
            }
        }
        return "<unknown/invalid>";
    }

    protected void log_generic() {
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                TTCN_Logger.log_event_uninitialized();
                break;
            }
            case OMIT_VALUE: {
                TTCN_Logger.log_event_str("omit");
                break;
            }
            case ANY_VALUE: {
                TTCN_Logger.log_char('?');
                break;
            }
            case ANY_OR_OMIT: {
                TTCN_Logger.log_char('*');
                break;
            }
            default: {
                TTCN_Logger.log_event_str("<unknown template selection>");
            }
        }
    }

    protected void log_ifpresent() {
        if (this.is_ifPresent) {
            TTCN_Logger.log_event_str(" ifpresent");
        }
    }

    protected void encode_text_base(Text_Buf text_buf) {
        text_buf.push_int(this.template_selection.getValue());
        text_buf.push_int(this.is_ifPresent ? 1 : 0);
    }

    protected void decode_text_base(Text_Buf text_buf) {
        this.template_selection = template_sel.getWithValue(text_buf.pull_int().get_int());
        this.is_ifPresent = text_buf.pull_int().get_int() == 1;
    }

    public boolean get_istemplate_kind(String type) {
        if ("value".equals(type)) {
            return this.is_value();
        }
        if ("list".equals(type)) {
            return this.template_selection == template_sel.VALUE_LIST;
        }
        if ("complement".equals(type)) {
            return this.template_selection == template_sel.COMPLEMENTED_LIST;
        }
        if ("?".equals(type) || "AnyValue".equals(type)) {
            return this.template_selection == template_sel.ANY_VALUE;
        }
        if ("*".equals(type) || "AnyValueOrNone".equals(type)) {
            return this.template_selection == template_sel.ANY_OR_OMIT;
        }
        if ("range".equals(type)) {
            return this.template_selection == template_sel.VALUE_RANGE;
        }
        if ("superset".equals(type)) {
            return this.template_selection == template_sel.SUPERSET_MATCH;
        }
        if ("subset".equals(type)) {
            return this.template_selection == template_sel.SUBSET_MATCH;
        }
        if ("omit".equals(type)) {
            return this.template_selection == template_sel.OMIT_VALUE;
        }
        if ("decmatch".equals(type)) {
            return this.template_selection == template_sel.DECODE_MATCH;
        }
        if ("ifpresent".equals(type)) {
            return this.is_ifPresent;
        }
        if ("pattern".equals(type)) {
            return this.template_selection == template_sel.STRING_PATTERN;
        }
        if ("AnyElement".equals(type) || "AnyElementsOrNone".equals(type) || "permutation".equals(type) || "length".equals(type)) {
            return false;
        }
        throw new TtcnError(MessageFormat.format("Incorrect second parameter ({0}) was passed to istemplatekind.", type));
    }

    public boolean get_istemplate_kind(TitanCharString type) {
        return this.get_istemplate_kind(type.get_value().toString());
    }

    public boolean is_omit() {
        return this.template_selection == template_sel.OMIT_VALUE && !this.is_ifPresent;
    }

    public boolean is_any_or_omit() {
        return this.template_selection == template_sel.ANY_OR_OMIT && !this.is_ifPresent;
    }

    public abstract Base_Template operator_assign(Base_Type var1);

    public abstract Base_Template operator_assign(Base_Template var1);

    public abstract Base_Template operator_assign(template_sel var1);

    public abstract boolean match(Base_Type var1, boolean var2);

    public abstract Base_Type valueof();

    public void set_type(template_sel template_type) {
        this.set_type(template_type, 0);
    }

    public abstract void set_type(template_sel var1, int var2);

    public abstract int n_list_elem();

    public abstract Base_Template list_item(int var1);

    public abstract void log();

    public abstract void log_match(Base_Type var1, boolean var2);

    public abstract void set_param(Param_Types.Module_Parameter var1);

    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        return null;
    }

    public boolean is_present() {
        return this.is_present(false);
    }

    public boolean is_present(boolean legacy) {
        if (this.template_selection == template_sel.UNINITIALIZED_TEMPLATE) {
            return false;
        }
        return !this.match_omit(legacy);
    }

    public boolean match_omit() {
        return this.match_omit(false);
    }

    public abstract boolean match_omit(boolean var1);

    public abstract void encode_text(Text_Buf var1);

    public abstract void decode_text(Text_Buf var1);

    public void check_restriction(template_res restriction, String name) {
        this.check_restriction(restriction, name, false);
    }

    public abstract void check_restriction(template_res var1, String var2, boolean var3);

    protected class DynamicMatchStruct<T> {
        public int ref_count;
        public IDynamicMatch<T> ptr;

        protected DynamicMatchStruct() {
        }
    }

    protected class ImplicationMatchStruct<T> {
        public T precondition;
        public T implied_template;

        protected ImplicationMatchStruct() {
        }
    }

    public static enum template_res {
        TR_VALUE,
        TR_OMIT,
        TR_PRESENT;

    }

    public static enum template_sel {
        UNINITIALIZED_TEMPLATE(0),
        SPECIFIC_VALUE(1),
        OMIT_VALUE(2),
        ANY_VALUE(3),
        ANY_OR_OMIT(4),
        VALUE_LIST(5),
        COMPLEMENTED_LIST(6),
        VALUE_RANGE(7),
        STRING_PATTERN(8),
        SUPERSET_MATCH(9),
        SUBSET_MATCH(10),
        DECODE_MATCH(11),
        CONJUNCTION_MATCH(12),
        IMPLICATION_MATCH(13),
        DYNAMIC_MATCH(14);

        private final int value;

        private template_sel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static template_sel getWithValue(int value) {
            return template_sel.values()[value];
        }
    }
}

