/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.LengthofExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.SizeOfExpression;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class SizeCheckInLoop
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "Length check operation in loop condition";

    public SizeCheckInLoop() {
        super(CodeSmellType.SIZECHECK_IN_LOOP);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (node instanceof For_Statement) {
            For_Statement s = (For_Statement)node;
            s.getFinalExpression().accept((ASTVisitor)new LoopVisitor(problems));
        } else if (node instanceof While_Statement) {
            While_Statement s = (While_Statement)node;
            s.getExpression().accept((ASTVisitor)new LoopVisitor(problems));
        } else if (node instanceof DoWhile_Statement) {
            DoWhile_Statement s = (DoWhile_Statement)node;
            s.getExpression().accept((ASTVisitor)new LoopVisitor(problems));
        } else {
            return;
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(3);
        ret.add(For_Statement.class);
        ret.add(While_Statement.class);
        ret.add(DoWhile_Statement.class);
        return ret;
    }

    protected static class LoopVisitor
    extends ASTVisitor {
        private final BaseCodeSmellSpotter.Problems problems;

        public LoopVisitor(BaseCodeSmellSpotter.Problems problems) {
            this.problems = problems;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof LengthofExpression) {
                LengthofExpression temp = (LengthofExpression)node;
                this.problems.report(temp.getLocation(), SizeCheckInLoop.ERROR_MESSAGE);
            } else if (node instanceof SizeOfExpression) {
                SizeOfExpression temp = (SizeOfExpression)node;
                this.problems.report(temp.getLocation(), SizeCheckInLoop.ERROR_MESSAGE);
            } else if (node instanceof Expression_Value) {
                return 3;
            }
            return 1;
        }
    }
}

