/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

public enum TernaryBool {
    TFALSE(false),
    TUNKNOWN,
    TTRUE(true);

    private static final TernaryBool[][] AND_TRUTH_TABLE;
    private static final TernaryBool[][] OR_TRUTH_TABLE;
    private static final TernaryBool[] NOT_TRUTH_TABLE;
    private final int value;

    private TernaryBool() {
        this.value = 1;
    }

    private TernaryBool(boolean b) {
        this.value = b ? 2 : 0;
    }

    public static TernaryBool fromBool(boolean b) {
        return b ? TTRUE : TFALSE;
    }

    public TernaryBool and(TernaryBool other) {
        return AND_TRUTH_TABLE[this.value][other.value];
    }

    public TernaryBool or(TernaryBool other) {
        return OR_TRUTH_TABLE[this.value][other.value];
    }

    public TernaryBool not() {
        return NOT_TRUTH_TABLE[this.value];
    }

    static {
        AND_TRUTH_TABLE = new TernaryBool[][]{{TFALSE, TFALSE, TFALSE}, {TFALSE, TUNKNOWN, TUNKNOWN}, {TFALSE, TUNKNOWN, TTRUE}};
        OR_TRUTH_TABLE = new TernaryBool[][]{{TFALSE, TUNKNOWN, TTRUE}, {TUNKNOWN, TUNKNOWN, TTRUE}, {TTRUE, TTRUE, TTRUE}};
        NOT_TRUTH_TABLE = new TernaryBool[]{TTRUE, TUNKNOWN, TFALSE};
    }
}

