/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_ActualParameter
extends ActualParameter {
    private final Reference reference;

    public Referenced_ActualParameter(Reference reference) {
        this.reference = reference;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public boolean hasSingleExpression(FormalParameter formalParameter) {
        if (this.reference != null) {
            if (formalParameter != null && formalParameter.getAssignmentType() != Assignment.Assignment_type.A_PAR_TIMER && formalParameter.getAssignmentType() != Assignment.Assignment_type.A_PAR_PORT) {
                boolean isTemplateParamater = formalParameter.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_INOUT || formalParameter.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_OUT;
                Assignment assignment = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                IType type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
                IType fieldType = type.getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.reference, 1, isTemplateParamater ? Expected_Value_type.EXPECTED_TEMPLATE : Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                IType actualParType = fieldType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType formalParType = formalParameter.getType(CompilationTimeStamp.getBaseTimestamp()).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                if (!actualParType.isIdentical(CompilationTimeStamp.getBaseTimestamp(), formalParType)) {
                    return false;
                }
            }
            return this.reference.hasSingleExpression();
        }
        return false;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, ExpressionStruct expression, FormalParameter formalParameter) {
        if (this.reference != null) {
            boolean needsConversion = false;
            IType formalParType = null;
            IType actualParType = null;
            boolean isTemplateParamater = false;
            if (formalParameter != null && formalParameter.getAssignmentType() != Assignment.Assignment_type.A_PAR_TIMER && formalParameter.getAssignmentType() != Assignment.Assignment_type.A_PAR_PORT) {
                isTemplateParamater = formalParameter.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_INOUT || formalParameter.getAssignmentType() == Assignment.Assignment_type.A_PAR_TEMP_OUT;
                Assignment assignment = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                IType type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
                IType fieldType = type.getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.reference, 1, isTemplateParamater ? Expected_Value_type.EXPECTED_TEMPLATE : Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                actualParType = fieldType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                formalParType = formalParameter.getType(CompilationTimeStamp.getBaseTimestamp()).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                if (!actualParType.isIdentical(CompilationTimeStamp.getBaseTimestamp(), formalParType)) {
                    needsConversion = true;
                }
            }
            StringBuilder expressionExpression = new StringBuilder();
            ExpressionStruct valueExpression = new ExpressionStruct();
            this.reference.generateCode(aData, valueExpression);
            Value.generateCodeExpressionOptionalFieldReference(aData, valueExpression, this.reference);
            if (valueExpression.preamble.length() > 0) {
                expression.preamble.append((CharSequence)valueExpression.preamble);
            }
            if (valueExpression.postamble.length() == 0) {
                expressionExpression.append((CharSequence)valueExpression.expression);
            } else {
                String tempId = aData.getTemporaryVariableName();
                expression.preamble.append(MessageFormat.format(" {0}({1})", tempId, valueExpression.expression));
                expression.preamble.append((CharSequence)valueExpression.postamble);
                expressionExpression.append(tempId);
            }
            if (needsConversion) {
                String convertedExpression;
                String formalParTypeName;
                String tempId2 = aData.getTemporaryVariableName();
                String string = formalParTypeName = isTemplateParamater ? formalParType.getGenNameTemplate(aData, expression.preamble) : formalParType.getGenNameValue(aData, expression.preamble);
                if (formalParameter.getAssignmentType() == Assignment.Assignment_type.A_PAR_VAL_OUT) {
                    String finalExpression = MessageFormat.format("final {0} {1} = new {0}();\n", formalParTypeName, tempId2);
                    expression.preamble.append(finalExpression);
                } else {
                    ExpressionStruct preCallConversionExpression = new ExpressionStruct();
                    expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", formalParTypeName, tempId2));
                    expression.preamble.append(MessageFormat.format("if({0}.is_bound()) '{'\n", expressionExpression.toString()));
                    convertedExpression = formalParType.generateConversion(aData, actualParType, expressionExpression.toString(), !isTemplateParamater, preCallConversionExpression);
                    String finalExpression = MessageFormat.format("{0}.operator_assign({1});\n", tempId2, convertedExpression);
                    if (preCallConversionExpression.preamble.length() > 0) {
                        expression.preamble.append((CharSequence)preCallConversionExpression.preamble);
                    }
                    if (preCallConversionExpression.postamble.length() > 0) {
                        expression.preamble.append((CharSequence)preCallConversionExpression.postamble);
                    }
                    expression.preamble.append(finalExpression);
                    expression.preamble.append("}\n");
                }
                expression.expression.append(tempId2);
                ExpressionStruct postCallConversionExpression = new ExpressionStruct();
                expression.postamble.append(MessageFormat.format("if({0}.is_bound()) '{'\n", tempId2));
                convertedExpression = actualParType.generateConversion(aData, formalParType, tempId2, !isTemplateParamater, postCallConversionExpression);
                if (postCallConversionExpression.preamble.length() > 0) {
                    expression.postamble.append((CharSequence)postCallConversionExpression.preamble);
                }
                if (postCallConversionExpression.postamble.length() > 0) {
                    expression.postamble.append((CharSequence)postCallConversionExpression.postamble);
                }
                expression.postamble.append(MessageFormat.format("{0}.operator_assign({1});\n", expressionExpression, convertedExpression));
                expression.postamble.append("}\n");
            } else {
                expression.expression.append((CharSequence)expressionExpression);
            }
        }
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous actual parameter `" + this.getFullName() + "''"));
    }
}

