/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.annotatedsourceeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STAnnotatedSourceEditorActivator;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STJFaceTextMessages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class STOverviewRuler
implements IOverviewRuler {
    private static final int INSET = 2;
    private static final int ANNOTATION_HEIGHT = 1;
    private static boolean ANNOTATION_HEIGHT_SCALABLE = true;
    private IAnnotationModel fModel;
    private ITextViewer fTextViewer;
    private Canvas fCanvas;
    private Canvas fHeader;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private int fLastMouseButtonActivityLine = -1;
    private int fAnnotationHeight = -1;
    private IAnnotationAccess fAnnotationAccess;
    private HeaderPainter fHeaderPainter;
    private Set<Object> fConfiguredAnnotationTypes = new HashSet<Object>();
    private Set<Object> fConfiguredHeaderAnnotationTypes = new HashSet<Object>();
    private Map<Object, Color> fAnnotationTypes2Colors = new HashMap<Object, Color>();
    private Map<Annotation, Color> fAnnotationColors = new HashMap<Annotation, Color>();
    private ISharedTextColors fSharedTextColors;
    private List<Object> fAnnotationsSortedByLayer = new ArrayList<Object>();
    private List<Integer> fLayersSortedByLayer = new ArrayList<Integer>();
    private Map fAllowedAnnotationTypes = new HashMap();
    private Map fAllowedHeaderAnnotationTypes = new HashMap();
    private List<Annotation> fCachedAnnotations = new ArrayList<Annotation>();

    public STOverviewRuler(IAnnotationAccess annotationAccess, int width, ISharedTextColors sharedColors) {
        this.fAnnotationAccess = annotationAccess;
        this.fWidth = width;
        this.fSharedTextColors = sharedColors;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public void setModel(IAnnotationModel model) {
        if (model != this.fModel || model != null) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.update();
        }
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fHitDetectionCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.fHeader = new Canvas(parent, 0);
        this.fCanvas = new Canvas(parent, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (STOverviewRuler.this.fTextViewer != null) {
                    STOverviewRuler.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                STOverviewRuler.this.handleDispose();
                STOverviewRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                STOverviewRuler.this.handleMouseDown(event);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                STOverviewRuler.this.handleMouseMove(event);
            }
        });
        if (this.fTextViewer != null) {
            this.fTextViewer.addTextListener((ITextListener)this.fInternalListener);
        }
        return this.fCanvas;
    }

    private void handleDispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextListener((ITextListener)this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        if (this.fHitDetectionCursor != null) {
            this.fHitDetectionCursor.dispose();
            this.fHitDetectionCursor = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fConfiguredHeaderAnnotationTypes.clear();
        this.fAllowedHeaderAnnotationTypes.clear();
        this.fAnnotationTypes2Colors.clear();
        this.fAnnotationsSortedByLayer.clear();
        this.fLayersSortedByLayer.clear();
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.fTextViewer instanceof ITextViewerExtension5) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    private void doPaint(GC gc) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 1;
        IDocument document = this.fTextViewer.getDocument();
        IRegion visible = this.fTextViewer.getVisibleRegion();
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = textWidget.getLineCount();
        Point size = this.fCanvas.getSize();
        int writable = JFaceTextUtil.computeLineHeight((StyledText)textWidget, (int)0, (int)maxLines, (int)maxLines);
        if (size.y > writable) {
            size.y = Math.max(writable - this.fHeader.getSize().y, 0);
        }
        for (Object annotationType : this.fAnnotationsSortedByLayer) {
            if (this.skip(annotationType)) continue;
            int[] style = new int[]{4, 2};
            int t = 0;
            while (t < style.length) {
                Color fill = null;
                Color stroke = null;
                FilterIterator e = new FilterIterator(annotationType, style[t]);
                if (annotationType.toString().compareTo(this.getAnnotationTypeColoredLines()) != 0) {
                    fill = this.getFillColor(annotationType, style[t] == 2);
                    stroke = this.getStrokeColor(annotationType, style[t] == 2);
                }
                while (e.hasNext()) {
                    Annotation a = e.next();
                    Position p = this.fModel.getPosition(a);
                    if (p == null || !p.overlapsWith(visible.getOffset(), visible.getLength())) continue;
                    if (a.getType().compareTo(this.getAnnotationTypeColoredLines()) == 0) {
                        fill = this.getFPFillColor(a, true);
                        stroke = this.getFPStrokeColor(a, false);
                    }
                    int annotationOffset = Math.max(p.getOffset(), visible.getOffset());
                    int annotationEnd = Math.min(p.getOffset() + p.getLength(), visible.getOffset() + visible.getLength());
                    int annotationLength = annotationEnd - annotationOffset;
                    try {
                        if (ANNOTATION_HEIGHT_SCALABLE) {
                            int numbersOfLines = document.getNumberOfLines(annotationOffset, annotationLength);
                            IRegion lastLine = document.getLineInformationOfOffset(annotationOffset + annotationLength);
                            if (lastLine.getOffset() == annotationOffset + annotationLength) {
                                hh = (numbersOfLines -= 2) * size.y / maxLines + 1;
                                if (hh < 1) {
                                    hh = 1;
                                }
                            } else {
                                hh = 1;
                            }
                        }
                        this.fAnnotationHeight = hh;
                        int startLine = textWidget.getLineAtOffset(annotationOffset - visible.getOffset());
                        int yy = Math.min(startLine * size.y / maxLines, size.y - hh);
                        if (fill != null) {
                            gc.setBackground(fill);
                            gc.fillRectangle(2, yy, size.x - 4, hh);
                        }
                        if (stroke == null) continue;
                        gc.setForeground(stroke);
                        r.x = 2;
                        r.y = yy;
                        r.width = size.x - 4;
                        r.height = hh;
                        gc.setLineWidth(1);
                        gc.drawRectangle(r);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++t;
            }
        }
    }

    private void doPaint1(GC gc) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 1;
        ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
        IDocument document = this.fTextViewer.getDocument();
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = textWidget.getLineCount();
        Point size = this.fCanvas.getSize();
        int writable = JFaceTextUtil.computeLineHeight((StyledText)textWidget, (int)0, (int)maxLines, (int)maxLines);
        if (size.y > writable) {
            size.y = Math.max(writable - this.fHeader.getSize().y, 0);
        }
        this.fCachedAnnotations.clear();
        if (this.fModel != null) {
            Iterator iter = this.fModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                if (annotation.isMarkedDeleted() || this.skip(annotation.getType())) continue;
                this.fCachedAnnotations.add(annotation);
            }
        }
        for (Object annotationType : this.fAnnotationsSortedByLayer) {
            if (this.skip(annotationType)) continue;
            int[] style = new int[]{4, 2};
            int t = 0;
            while (t < style.length) {
                FilterIterator e = new FilterIterator(annotationType, style[t], this.fCachedAnnotations.iterator());
                Color fill = null;
                Color stroke = null;
                if (annotationType.toString().compareTo(this.getAnnotationTypeColoredLines()) != 0) {
                    fill = this.getFillColor(annotationType, style[t] == 2);
                    stroke = this.getStrokeColor(annotationType, style[t] == 2);
                }
                while (e.hasNext()) {
                    IRegion widgetRegion;
                    Annotation a = e.next();
                    Position p = this.fModel.getPosition(a);
                    if (p == null || (widgetRegion = extension.modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength()))) == null) continue;
                    if (a.getType().compareTo(this.getAnnotationTypeColoredLines()) == 0) {
                        fill = this.getFPFillColor(a, true);
                        stroke = this.getFPStrokeColor(a, false);
                    }
                    try {
                        if (ANNOTATION_HEIGHT_SCALABLE) {
                            int numbersOfLines = document.getNumberOfLines(p.getOffset(), p.getLength());
                            IRegion lastLine = document.getLineInformationOfOffset(p.getOffset() + p.getLength());
                            if (lastLine.getOffset() == p.getOffset() + p.getLength()) {
                                hh = (numbersOfLines -= 2) * size.y / maxLines + 1;
                                if (hh < 1) {
                                    hh = 1;
                                }
                            } else {
                                hh = 1;
                            }
                        }
                        this.fAnnotationHeight = hh;
                        int startLine = textWidget.getLineAtOffset(widgetRegion.getOffset());
                        int yy = Math.min(startLine * size.y / maxLines, size.y - hh);
                        if (fill != null) {
                            gc.setBackground(fill);
                            gc.fillRectangle(2, yy, size.x - 4, hh);
                        }
                        if (stroke == null) continue;
                        gc.setForeground(stroke);
                        r.x = 2;
                        r.y = yy;
                        r.width = size.x - 4;
                        r.height = hh;
                        gc.setLineWidth(1);
                        gc.drawRectangle(r);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++t;
            }
        }
        this.fCachedAnnotations.clear();
    }

    public void update() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    STOverviewRuler.this.redraw();
                    STOverviewRuler.this.updateHeader();
                }
            });
        }
    }

    private void redraw() {
        if (this.fTextViewer == null || this.fModel == null) {
            return;
        }
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    private int[] toLineNumbers(int y_coordinate) {
        int maxLines;
        int rulerLength = this.fCanvas.getSize().y;
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int writable = JFaceTextUtil.computeLineHeight((StyledText)textWidget, (int)0, (int)(maxLines = textWidget.getContent().getLineCount()), (int)maxLines);
        if (rulerLength > writable) {
            rulerLength = Math.max(writable - this.fHeader.getSize().y, 0);
        }
        if (y_coordinate >= writable || y_coordinate >= rulerLength) {
            return new int[]{-1, -1};
        }
        int[] lines = new int[2];
        int pixel0 = Math.max(y_coordinate - 1, 0);
        int pixel1 = Math.min(rulerLength, y_coordinate + 1);
        rulerLength = Math.max(rulerLength, 1);
        lines[0] = pixel0 * maxLines / rulerLength;
        lines[1] = pixel1 * maxLines / rulerLength;
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            lines[0] = extension.widgetLine2ModelLine(lines[0]);
            lines[1] = extension.widgetLine2ModelLine(lines[1]);
        } else {
            try {
                IRegion visible = this.fTextViewer.getVisibleRegion();
                int lineNumber = this.fTextViewer.getDocument().getLineOfOffset(visible.getOffset());
                lines[0] = lines[0] + lineNumber;
                lines[1] = lines[1] + lineNumber;
            }
            catch (BadLocationException badLocationException) {}
        }
        return lines;
    }

    private Position getAnnotationPosition(int[] lineNumbers, boolean ignoreSelectedAnnotation) {
        if (lineNumbers[0] == -1) {
            return null;
        }
        Position found = null;
        try {
            IDocument d = this.fTextViewer.getDocument();
            IRegion line = d.getLineInformation(lineNumbers[0]);
            Point currentSelection = this.fTextViewer.getSelectedRange();
            int start = line.getOffset();
            line = d.getLineInformation(lineNumbers[lineNumbers.length - 1]);
            int end = line.getOffset() + line.getLength();
            int i = this.fAnnotationsSortedByLayer.size() - 1;
            while (i >= 0) {
                Object annotationType = this.fAnnotationsSortedByLayer.get(i);
                FilterIterator e = new FilterIterator(annotationType, 6);
                while (e.hasNext() && found == null) {
                    Position p;
                    Annotation a = e.next();
                    if (a.isMarkedDeleted() || this.skip(a.getType()) || (p = this.fModel.getPosition(a)) == null) continue;
                    int posOffset = p.getOffset();
                    int posEnd = posOffset + p.getLength();
                    IRegion region = d.getLineInformationOfOffset(posEnd);
                    if (posEnd > posOffset && region.getOffset() == posEnd) {
                        region = d.getLineInformationOfOffset(--posEnd);
                    }
                    if (posOffset > end || posEnd < start || !ignoreSelectedAnnotation && currentSelection.x == posOffset && currentSelection.y == p.getLength()) continue;
                    found = p;
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return found;
    }

    private int findBestMatchingLineNumber(int[] lineNumbers) {
        Position pos;
        block4: {
            if (lineNumbers == null || lineNumbers.length < 1) {
                return -1;
            }
            try {
                pos = this.getAnnotationPosition(lineNumbers, true);
                if (pos != null) break block4;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return this.fTextViewer.getDocument().getLineOfOffset(pos.getOffset());
    }

    private void handleMouseDown(MouseEvent event) {
        if (this.fTextViewer != null) {
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getAnnotationPosition(lines, false);
            if (p != null) {
                this.fTextViewer.revealRange(p.getOffset(), p.getLength());
                this.fTextViewer.setSelectedRange(p.getOffset(), p.getLength());
            }
            this.fTextViewer.getTextWidget().setFocus();
        }
        this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(event.y);
    }

    private void handleMouseMove(MouseEvent event) {
        if (this.fTextViewer != null) {
            Cursor cursor;
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getAnnotationPosition(lines, true);
            Cursor cursor2 = cursor = p != null ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    public void addAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.add(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void removeAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.remove(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void setAnnotationTypeLayer(Object annotationType, int layer) {
        int j = this.fAnnotationsSortedByLayer.indexOf(annotationType);
        if (j != -1) {
            this.fAnnotationsSortedByLayer.remove(j);
            this.fLayersSortedByLayer.remove(j);
        }
        if (layer >= 0) {
            int i = 0;
            int size = this.fLayersSortedByLayer.size();
            while (i < size && layer >= this.fLayersSortedByLayer.get(i)) {
                ++i;
            }
            this.fLayersSortedByLayer.add(i, layer);
            this.fAnnotationsSortedByLayer.add(i, annotationType);
        }
    }

    public void setAnnotationColor(Annotation annotation, Color color) {
        if (color != null) {
            this.fAnnotationColors.put(annotation, color);
        } else {
            this.fAnnotationColors.remove(annotation);
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fAnnotationTypes2Colors.put(annotationType, color);
        } else {
            this.fAnnotationTypes2Colors.remove(annotationType);
        }
    }

    private boolean skip(Object annotationType) {
        return !this.contains(annotationType, this.fAllowedAnnotationTypes, this.fConfiguredAnnotationTypes);
    }

    private boolean skipInHeader(Object annotationType) {
        return !this.contains(annotationType, this.fAllowedHeaderAnnotationTypes, this.fConfiguredHeaderAnnotationTypes);
    }

    private boolean contains(Object annotationType, Map allowed, Set configured) {
        Boolean cached = (Boolean)allowed.get(annotationType);
        if (cached != null) {
            return cached;
        }
        boolean covered = this.isCovered(annotationType, configured);
        allowed.put(annotationType, covered ? Boolean.TRUE : Boolean.FALSE);
        return covered;
    }

    private boolean isCovered(Object annotationType, Set configured) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)this.fAnnotationAccess;
            Iterator e = configured.iterator();
            while (e.hasNext()) {
                if (!extension.isSubtype(annotationType, e.next())) continue;
                return true;
            }
            return false;
        }
        return configured.contains(annotationType);
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
    }

    private static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    private static boolean isDark(RGB rgb) {
        return STOverviewRuler.greyLevel(rgb) > 128.0;
    }

    private Color getColor(Object annotationType, double scale) {
        Color base = this.findColor(annotationType);
        return this.getInterpolatedColor(base, scale);
    }

    private Color getFPColor(Object annotation, double scale) {
        Color base = this.fAnnotationColors.get(annotation);
        return this.getInterpolatedColor(base, scale);
    }

    private Color getInterpolatedColor(Color base, double scale) {
        if (base == null) {
            return null;
        }
        RGB baseRGB = base.getRGB();
        RGB background = this.fCanvas.getBackground().getRGB();
        boolean darkBase = STOverviewRuler.isDark(baseRGB);
        boolean darkBackground = STOverviewRuler.isDark(background);
        if (darkBase && darkBackground) {
            background = new RGB(255, 255, 255);
        } else if (!darkBase && !darkBackground) {
            background = new RGB(0, 0, 0);
        }
        return this.fSharedTextColors.getColor(STOverviewRuler.interpolate(baseRGB, background, scale));
    }

    private Color findColor(Object annotationType) {
        IAnnotationAccessExtension extension;
        Object[] superTypes;
        Color color = this.fAnnotationTypes2Colors.get(annotationType);
        if (color != null) {
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (superTypes = (extension = (IAnnotationAccessExtension)this.fAnnotationAccess).getSupertypes(annotationType)) != null) {
            int i = 0;
            while (i < superTypes.length) {
                color = this.fAnnotationTypes2Colors.get(superTypes[i]);
                if (color != null) {
                    return color;
                }
                ++i;
            }
        }
        return null;
    }

    private Color getStrokeColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary ? 0.5 : 0.2);
    }

    private Color getFPStrokeColor(Object annotation, boolean temporary) {
        return this.getFPColor(annotation, temporary ? 0.5 : 0.2);
    }

    private Color getFillColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary ? 0.9 : 0.6);
    }

    private Color getFPFillColor(Object annotation, boolean temporary) {
        return this.getFPColor(annotation, temporary ? 0.9 : 0.6);
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.fLastMouseButtonActivityLine;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fTextViewer == null || y_coordinate == -1) {
            return -1;
        }
        int[] lineNumbers = this.toLineNumbers(y_coordinate);
        int bestLine = this.findBestMatchingLineNumber(lineNumbers);
        if (bestLine == -1 && lineNumbers.length > 0) {
            return lineNumbers[0];
        }
        return bestLine;
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public int getAnnotationHeight() {
        return this.fAnnotationHeight;
    }

    public boolean hasAnnotation(int y) {
        return this.findBestMatchingLineNumber(this.toLineNumbers(y)) != -1;
    }

    public Control getHeaderControl() {
        return this.fHeader;
    }

    public void addHeaderAnnotationType(Object annotationType) {
        this.fConfiguredHeaderAnnotationTypes.add(annotationType);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    public void removeHeaderAnnotationType(Object annotationType) {
        this.fConfiguredHeaderAnnotationTypes.remove(annotationType);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    private void updateHeader() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        Object colorType = null;
        int i = this.fAnnotationsSortedByLayer.size() - 1;
        block0: while (i >= 0) {
            Object annotationType = this.fAnnotationsSortedByLayer.get(i);
            if (!this.skipInHeader(annotationType) && !this.skip(annotationType)) {
                FilterIterator e = new FilterIterator(annotationType, 14);
                while (e.hasNext()) {
                    if (e.next() == null) continue;
                    colorType = annotationType;
                    break block0;
                }
            }
            --i;
        }
        Color color = null;
        if (colorType != null) {
            color = this.findColor(colorType);
        }
        if (color == null) {
            if (this.fHeaderPainter != null) {
                this.fHeaderPainter.setColor(null);
            }
        } else {
            if (this.fHeaderPainter == null) {
                this.fHeaderPainter = new HeaderPainter();
                this.fHeader.addPaintListener((PaintListener)this.fHeaderPainter);
            }
            this.fHeaderPainter.setColor(color);
        }
        this.fHeader.redraw();
        this.updateHeaderToolTipText();
    }

    private void updateHeaderToolTipText() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        this.fHeader.setToolTipText(null);
        if (!(this.fAnnotationAccess instanceof IAnnotationAccessExtension)) {
            return;
        }
        String overview = "";
        int i = this.fAnnotationsSortedByLayer.size() - 1;
        while (i >= 0) {
            Object annotationType = this.fAnnotationsSortedByLayer.get(i);
            if (!this.skipInHeader(annotationType) && !this.skip(annotationType)) {
                int count = 0;
                String annotationTypeLabel = null;
                FilterIterator e = new FilterIterator(annotationType, 14);
                while (e.hasNext()) {
                    Annotation annotation = e.next();
                    if (annotation == null) continue;
                    if (annotationTypeLabel == null) {
                        annotationTypeLabel = ((IAnnotationAccessExtension)this.fAnnotationAccess).getTypeLabel(annotation);
                    }
                    ++count;
                }
                if (annotationTypeLabel != null) {
                    if (overview.length() > 0) {
                        overview = String.valueOf(overview) + "\n";
                    }
                    overview = String.valueOf(overview) + STJFaceTextMessages.getFormattedString("OverviewRulerHeader.toolTipTextEntry", new Object[]{annotationTypeLabel, new Integer(count)});
                }
            }
            --i;
        }
        if (overview.length() > 0) {
            this.fHeader.setToolTipText(overview);
        }
    }

    private String getAnnotationTypeColoredLines() {
        return String.valueOf(STAnnotatedSourceEditorActivator.getUniqueIdentifier()) + STAnnotatedSourceEditorActivator.getAnnotationType();
    }

    class FilterIterator
    implements Iterator<Annotation> {
        static final int TEMPORARY = 2;
        static final int PERSISTENT = 4;
        static final int IGNORE_BAGS = 8;
        private Iterator<?> fIterator;
        private Object fType;
        private Annotation fNext;
        private int fStyle;

        public FilterIterator(Object annotationType, int style) {
            this.fType = annotationType;
            this.fStyle = style;
            if (STOverviewRuler.this.fModel != null) {
                this.fIterator = STOverviewRuler.this.fModel.getAnnotationIterator();
                this.skip();
            }
        }

        public FilterIterator(Object annotationType, int style, Iterator<?> iterator) {
            this.fType = annotationType;
            this.fStyle = style;
            this.fIterator = iterator;
            this.skip();
        }

        private void skip() {
            boolean temp = (this.fStyle & 2) != 0;
            boolean pers = (this.fStyle & 4) != 0;
            boolean ignr = (this.fStyle & 8) != 0;
            while (this.fIterator.hasNext()) {
                Annotation next = (Annotation)this.fIterator.next();
                if (next.isMarkedDeleted() || ignr && next instanceof AnnotationBag) continue;
                this.fNext = next;
                String annotationType = next.getType();
                if (this.fType != null && !this.isSubtype(annotationType)) continue;
                if (temp && pers) {
                    return;
                }
                if (pers && next.isPersistent()) {
                    return;
                }
                if (!temp || next.isPersistent()) continue;
                return;
            }
            this.fNext = null;
        }

        private boolean isSubtype(Object annotationType) {
            if (STOverviewRuler.this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
                IAnnotationAccessExtension extension = (IAnnotationAccessExtension)STOverviewRuler.this.fAnnotationAccess;
                return extension.isSubtype(annotationType, this.fType);
            }
            return this.fType.equals(annotationType);
        }

        @Override
        public boolean hasNext() {
            return this.fNext != null;
        }

        @Override
        public Annotation next() {
            try {
                Annotation annotation = this.fNext;
                return annotation;
            }
            finally {
                if (this.fIterator != null) {
                    this.skip();
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeaderPainter
    implements PaintListener {
        private Color fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = STOverviewRuler.this.fSharedTextColors.getColor(ViewForm.borderInsideRGB);
        }

        public void setColor(Color color) {
            this.fIndicatorColor = color;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft == null ? this.fSeparatorColor : topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight == null ? this.fSeparatorColor : bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            Point s = STOverviewRuler.this.fHeader.getSize();
            if (this.fIndicatorColor != null) {
                e.gc.setBackground(this.fIndicatorColor);
                Rectangle r = new Rectangle(2, (s.y - 2) / 2, s.x - 4, 2);
                e.gc.fillRectangle(r);
                Display d = STOverviewRuler.this.fHeader.getDisplay();
                if (d != null) {
                    this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, null, null);
                }
            }
            e.gc.setForeground(this.fSeparatorColor);
            e.gc.setLineWidth(1);
            e.gc.drawLine(0, s.y - 1, s.x - 1, s.y - 1);
        }
    }

    class InternalListener
    implements ITextListener,
    IAnnotationModelListener {
        InternalListener() {
        }

        public void textChanged(TextEvent e) {
            if (STOverviewRuler.this.fTextViewer != null && e.getDocumentEvent() == null && e.getViewerRedrawState()) {
                STOverviewRuler.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel model) {
            STOverviewRuler.this.update();
        }
    }
}

