/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.internal.engines.blind.BlindVizEnginePlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextChecker {
    private static final String NULL_STRING = "";
    private static final String KIGOU = "(\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})";
    private static final String NIHONGO = "(\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana})";
    private static final String KANJI = "(\\p{InCJKUnifiedIdeographs})";
    private static final String ALT_TEXT_PROPERTIES_FILE = "altText.properties";
    private static final String INAPP_ALT = "blindViz.inappropriateAlt_";
    private static final String POSSIBLE_INAPP_ALT = "blindViz.possible_inappAlt_";
    private static TextChecker INSTANCE;
    private Set<String> ngwordset = new TreeSet<String>();
    private Set<String> ngwordset2 = new TreeSet<String>();
    private Set<String> ngPatterns = new HashSet<String>();
    private IPreferenceStore pref = BlindVizEnginePlugin.getDefault().getPreferenceStore();

    private TextChecker() {
        if (!this.pref.getBoolean("blindViz.not_first_time")) {
            Properties properties = new Properties();
            try {
                Object object = FileLocator.openStream((Bundle)Platform.getBundle((String)"org.eclipse.actf.visualization.engines.blind"), (IPath)new Path("config/altText.properties"), (boolean)false);
                if (object != null) {
                    properties.load((InputStream)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (Object object : properties.keySet()) {
                String string;
                String string2 = (String)object;
                if (string2.startsWith(INAPP_ALT)) {
                    string = properties.getProperty(string2);
                    if (string.length() <= 0) continue;
                    this.ngwordset.add(string);
                    continue;
                }
                if (!string2.startsWith(POSSIBLE_INAPP_ALT) || (string = properties.getProperty(string2)).length() <= 0) continue;
                this.ngwordset2.add(string);
            }
            this.resetPreferences();
        } else {
            String string;
            int n = 0;
            while (this.pref.contains(INAPP_ALT + n)) {
                string = this.pref.getString(INAPP_ALT + n);
                if (string.length() > 0) {
                    this.ngwordset.add(string);
                }
                ++n;
            }
            n = 0;
            while (this.pref.contains(POSSIBLE_INAPP_ALT + n)) {
                string = this.pref.getString(POSSIBLE_INAPP_ALT + n);
                if (string.length() > 0) {
                    this.ngwordset2.add(string);
                }
                ++n;
            }
        }
        this.ngPatterns.add("\u753b\u50cf\\s*\\d+");
    }

    public static synchronized TextChecker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TextChecker();
        }
        return INSTANCE;
    }

    public boolean isRedundantText(String string, String string2) {
        if (string != null && string.length() > 1 && string2.length() > 1) {
            String string3 = string.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
            string3 = string3.trim();
            String string4 = string2.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
            if ((string4 = string4.trim()).equalsIgnoreCase(string3)) {
                return true;
            }
        }
        return false;
    }

    public boolean isInappropriateAlt(String string) {
        String string2 = string.trim();
        return this.ngwordset.contains(string2 = string2.toLowerCase()) || this.isEndWithImageExt(string2);
    }

    public int checkInappropriateAlt(String string) {
        String[] stringArray = string.toLowerCase().split("((\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})|\\p{Punct}|\\p{Space})");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].length() > 0) {
                ++n2;
            }
            n3 += stringArray[n4].length();
            if (this.ngwordset2.contains(stringArray[n4])) {
                ++n;
            }
            ++n4;
        }
        n4 = string.length();
        if (n4 > 0 && string.matches(".*(\\p{Alpha}\\p{Space}){3,}.*")) {
            return 3;
        }
        if (n4 > 0 && (double)n3 / (double)n4 < 0.5 && !string.matches("\\p{Space}*")) {
            return 1;
        }
        if ((double)n / (double)n2 > 0.6) {
            return 2;
        }
        if ((double)n / (double)n2 > 0.3) {
            return 1;
        }
        return 0;
    }

    private boolean isEndWithImageExt(String string) {
        String string2 = string.trim().toLowerCase();
        String string3 = "\\p{Print}*\\.(jpg|jpeg|gif|png|bmp|tiff)";
        return string2.matches(string3);
    }

    public boolean isSeparatedJapaneseChars(String string) {
        String string2;
        String string3 = string.trim();
        return (string3 = string3.toLowerCase()).matches(string2 = ".*\\b(\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana})[\\p{Space}\u3000\u00a0]+(\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana})\\b.*");
    }

    public Set<String> getInappropriateALTSet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.ngwordset);
        return hashSet;
    }

    private void resetPreferences() {
        int n = 0;
        for (String string : this.ngwordset) {
            this.pref.setValue(INAPP_ALT + n, string);
            ++n;
        }
        int n2 = n;
        while (this.pref.contains(INAPP_ALT + n2)) {
            this.pref.setValue(INAPP_ALT + n2, NULL_STRING);
            ++n2;
        }
        n = 0;
        for (String string : this.ngwordset2) {
            this.pref.setValue(POSSIBLE_INAPP_ALT + n, string);
            ++n;
        }
        int n3 = n;
        while (this.pref.contains(POSSIBLE_INAPP_ALT + n3)) {
            this.pref.setValue(POSSIBLE_INAPP_ALT + n3, NULL_STRING);
            ++n3;
        }
    }

    public void setInappropriateAltSet(Set<String> set) {
        if (set != null) {
            this.ngwordset = set;
        }
        this.resetPreferences();
    }

    public TextCheckResult checkAlt(String string) {
        return this.checkAlt(string, null, new TreeSet<String>());
    }

    public TextCheckResult checkAlt(String string, String string2) {
        return this.checkAlt(string, string2, new TreeSet<String>());
    }

    public TextCheckResult checkAlt(String string, Set<String> set) {
        return this.checkAlt(string, null, set);
    }

    public TextCheckResult checkAlt(String string, String string2, Set<String> set) {
        Object object;
        String string3 = string;
        int n = string.length();
        if ((string = string.toLowerCase()).equals(NULL_STRING)) {
            return TextCheckResult.NULL;
        }
        assert (n > 0);
        if (string.matches("[\\p{Space}\\u3000\\u00A0]+")) {
            if (string.matches(".*\\u00A0.*")) {
                return TextCheckResult.BLANK_NBSP;
            }
            return TextCheckResult.BLANK;
        }
        if (this.ngwordset.contains(string = string.trim()) || set.contains(string)) {
            return TextCheckResult.NG_WORD;
        }
        Object object2 = this.ngPatterns.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!string.matches((String)object)) continue;
            return TextCheckResult.NG_WORD;
        }
        if (string2 != null && ((Matcher)(object = Pattern.compile(".*?([^/]+)").matcher(string2.toLowerCase()))).matches() && string.equals(object2 = ((Matcher)object).group(1))) {
            return TextCheckResult.SAME_AS_SRC;
        }
        if (this.isEndWithImageExt(string)) {
            return TextCheckResult.IMG_EXT;
        }
        if (string.matches(".*(\\p{Alpha}\\p{Space}){3,}.*")) {
            return TextCheckResult.SPACE_SEPARATED;
        }
        if (this.isSeparatedJapaneseChars(string)) {
            return TextCheckResult.SPACE_SEPARATED_JP;
        }
        object = Arrays.asList(string.toLowerCase().split("((\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})|\\p{Punct}|\\p{Space})"));
        int n2 = 0;
        int n3 = 0;
        Iterator<String> iterator = object.iterator();
        while (iterator.hasNext()) {
            String string4 = iterator.next();
            string4.length();
            if (string4.length() > 0) {
                ++n3;
            }
            if (!this.ngwordset2.contains(string4)) continue;
            ++n2;
        }
        if (this.isAsciiArtString(string3)) {
            return TextCheckResult.ASCII_ART;
        }
        if ((double)n2 / (double)n3 > 0.6) {
            return TextCheckResult.INCLUDING_MANY_NG_WORD;
        }
        if ((double)n2 / (double)n3 > 0.3) {
            return TextCheckResult.INCLUDING_NG_WORD;
        }
        return TextCheckResult.OK;
    }

    public boolean isAsciiArtString(String string) {
        int n = string.length();
        string = string.toLowerCase();
        List<String> list = Arrays.asList(string.toLowerCase().split("((\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})|\\p{Punct}|\\p{Space})"));
        int n2 = 0;
        for (String string2 : list) {
            n2 += string2.length();
        }
        boolean bl = string.matches("[\\p{Space}\\u3000\\u00A0]*");
        return n > 0 && (double)n2 / (double)n < 0.5 && !bl;
    }
}

