/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy;

import java.util.ArrayList;
import org.eclipse.actf.util.internal.httpproxy.IObjectPool;

public class ObjectPoolImpl
implements IObjectPool {
    private final String name;
    private ArrayList<Object> pool;
    private int waitInLine;

    public synchronized boolean add(Object object) {
        boolean bl = this.pool.add(object);
        if (bl && this.waitInLine > 0) {
            this.notify();
        }
        return bl;
    }

    public synchronized Object take() {
        if (this.pool.size() == 0) {
            return null;
        }
        return this.pool.remove(0);
    }

    public synchronized Object take(int n) throws InterruptedException {
        long l = System.currentTimeMillis();
        ++this.waitInLine;
        while (this.pool.size() == 0) {
            this.wait(n);
            if (n <= 0 || System.currentTimeMillis() - l <= (long)n) continue;
            --this.waitInLine;
            return null;
        }
        --this.waitInLine;
        return this.pool.remove(0);
    }

    public ObjectPoolImpl(String string) {
        this.name = string;
        this.pool = new ArrayList();
        this.waitInLine = 0;
    }

    public String getName() {
        return this.name;
    }
}

