/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.internal.flash.proxy.Messages;
import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProxyPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private List<Group> groups = new ArrayList<Group>();

    protected Group createFieldGroup(String string) {
        Group group = new Group(this.getFieldEditorParent(), 0);
        if (string != null) {
            group.setText(string);
        }
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        this.groups.add(group);
        return group;
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        int n = ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns;
        int n2 = 0;
        while (n2 < this.groups.size()) {
            Group group = this.groups.get(n2);
            GridLayout gridLayout = (GridLayout)group.getLayout();
            GridData gridData = (GridData)group.getLayoutData();
            gridLayout.numColumns = n;
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridData.horizontalSpan = n;
            ++n2;
        }
    }

    public ProxyPreferencePage() {
        super(1);
        this.setPreferenceStore(ProxyPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Group group = this.createFieldGroup(Messages.proxy_pref_description);
        this.addField((FieldEditor)new RadioGroupFieldEditor("ProxyType", Messages.proxy_type, 1, (String[][])new String[][]{{Messages.proxy_none, "PROXY_NONE"}, {Messages.proxy_session, "PROXY_SESSION"}, {Messages.proxy_global, "PROXY_GLOBAL"}}, (Composite)group));
        if (Platform.inDebugMode()) {
            this.addField((FieldEditor)new RadioGroupFieldEditor("ProxySWFMethod", Messages.proxy_swfmethod, 1, (String[][])new String[][]{{Messages.proxy_swfmethod_none, "PROXY_SWF_METHOD_NONE"}, {Messages.proxy_swfmethod_bootloader, "PROXY_SWF_METHOD_BOOTLOADER"}}, (Composite)group));
        }
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("PROXY_PORT", Messages.proxy_port, (Composite)group);
        integerFieldEditor.setValidRange(0, 65535);
        this.addField((FieldEditor)integerFieldEditor);
        IntegerFieldEditor integerFieldEditor2 = new IntegerFieldEditor("Timeout", Messages.proxy_timeout, (Composite)group);
        integerFieldEditor2.setValidRange(0, 99);
        this.addField((FieldEditor)integerFieldEditor2);
        IntegerFieldEditor integerFieldEditor3 = new IntegerFieldEditor("SWFMinimumVersion", Messages.proxy_swf_version, (Composite)group);
        integerFieldEditor3.setValidRange(3, 99);
        this.addField((FieldEditor)integerFieldEditor3);
        this.addField((FieldEditor)new RadioGroupFieldEditor("CacheClearMode", Messages.proxy_cache_clear, 1, (String[][])new String[][]{{Messages.proxy_cache_clear_when_startup, "CACHE_CLEAR_WHEN_STARTUP"}, {Messages.proxy_confirm_cache_clear, "CONFIRM_WHEN_STARTUP"}, {Messages.proxy_no_cache_clear, "NO_CACHE_CLEAR"}}, this.getFieldEditorParent(), true));
    }

    public void init(IWorkbench iWorkbench) {
    }
}

