/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class JapaneseEncodingDetector {
    private static final int J_SJIS = 0;
    private static final int J_EUC = 1;
    private static final int J_JIS = 2;
    private static final int J_MIX = 3;
    private static final int J_UTF8 = 4;
    private static final int LATIN1 = 5;
    private static final String JIS = "ISO-2022-JP";
    private static final String EUC = "EUC-JP";
    private static final String SJIS = "Shift_JIS";
    private static final String UTF_8 = "UTF8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final byte JIS_ESCAPE = 27;
    private static final byte JIS_DOUBLE = 36;
    private static final byte JIS_SINGLE = 40;
    private static final byte JIS_B = 66;
    private static final byte JIS_AT = 64;
    private static final byte JIS_D = 68;
    private static final byte JIS_J = 74;
    private static final byte JIS_I = 73;
    private static final byte JIS_KANA_PAYLOAD_BEGIN = 33;
    private static final byte JIS_KANA_PAYLOAD_END = 95;
    private static final byte JIS_D_PAYLOAD_BEGIN = 33;
    private static final byte JIS_D_PAYLOAD_END = 126;
    private static final byte E_KANA_1ST = -114;
    private static final byte E_HOJO_1ST = -113;
    private static final byte E_KISYU_1ST = -96;
    private static final byte E_KANJI_BEGIN = -95;
    private static final byte E_KANJI_END = -2;
    private static final byte E_KANA_BEGIN = -95;
    private static final byte E_KANA_END = -33;
    private static final byte E_PAYLOAD_BEGIN = -96;
    private static final byte E_PAYLOAD_END = -1;
    private static final byte S1st1begin = -127;
    private static final byte S1st1end = -97;
    private static final byte S1st2begin = -32;
    private static final byte S1st2end = -17;
    private static final byte S2nd1begin = 64;
    private static final byte S2nd1end = 126;
    private static final byte S2nd2begin = -128;
    private static final byte S2nd2end = -4;
    private static final byte Skanabegin = -95;
    private static final byte Skanaend = -33;
    private static final byte ASCII_BEGIN = 0;
    private static final byte ASCII_END = 127;
    private static final byte U_2BYTE_BEGIN = -64;
    private static final byte U_2BYTE_END = -33;
    private static final byte U_3BYTE_BEGIN = -32;
    private static final byte U_3BYTE_END = -17;
    private static final byte U_4BYTE_BEGIN = -16;
    private static final byte U_4BYTE_END = -9;
    private static final byte U_PAYLOAD_BEGIN = -128;
    private static final byte U_PAYLOAD_END = -65;
    private static final byte LATIN_BEGIN = -96;
    private static final byte LATIN_END = -1;
    private byte[] buf = new byte[8192];
    private int length;
    private int errorJIS;
    private int errorUTF8;
    private int errorLATIN1;
    private int errorSJIS;
    private int errorEUC;
    private InputStream is;
    private Vector<Integer> eucRemoveV = new Vector();

    public JapaneseEncodingDetector(InputStream inputStream) {
        this.is = inputStream;
    }

    private String toString(int n) {
        switch (n) {
            case 4: {
                return UTF_8;
            }
            case 2: {
                return JIS;
            }
            case 1: {
                return EUC;
            }
            case 5: {
                return ISO_8859_1;
            }
        }
        return SJIS;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.buf, 0, byArray, 0, this.length);
        return byArray;
    }

    private void removeKisyuIzonEUC() {
        int n = this.eucRemoveV.size() - 1;
        while (n > -1) {
            byte[] byArray = new byte[this.length - 2];
            int n2 = this.eucRemoveV.get(n);
            System.arraycopy(this.buf, 0, byArray, 0, n2);
            System.arraycopy(this.buf, n2 + 2, byArray, n2, this.length - n2 - 2);
            this.buf = byArray;
            this.length -= 2;
            --n;
        }
    }

    private boolean isJIS(byte[] byArray, int n) {
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        byte by = this.buf[n2];
        while (n2 < n) {
            if (by == 27 && n2 + 2 < n) {
                byte by2 = this.buf[n2 + 1];
                byte by3 = this.buf[n2 + 2];
                if (by2 == 40) {
                    switch (by3) {
                        case 66: 
                        case 74: {
                            bl = true;
                            bl2 = false;
                            bl3 = false;
                            n2 += 3;
                            bl4 = true;
                            break;
                        }
                        case 73: {
                            bl2 = true;
                            bl = false;
                            bl3 = false;
                            n2 += 3;
                            bl4 = true;
                            break;
                        }
                        default: {
                            ++this.errorJIS;
                            ++n2;
                            break;
                        }
                    }
                } else if (by2 == 36) {
                    switch (by3) {
                        case 64: 
                        case 66: 
                        case 68: {
                            bl3 = true;
                            bl = false;
                            bl2 = false;
                            n2 += 3;
                            bl4 = true;
                            break;
                        }
                        default: {
                            ++this.errorJIS;
                            ++n2;
                            break;
                        }
                    }
                } else {
                    ++this.errorJIS;
                    ++n2;
                }
            } else if (bl3 && n2 + 1 < n && this.isPayloadJISkanji(by) && this.isPayloadJISkanji(this.buf[n2 + 1])) {
                n2 += 2;
            } else if (bl && this.isASCII(by)) {
                ++n2;
            } else if (bl2 && this.isPayloadJISkana(by)) {
                ++n2;
            } else {
                ++this.errorJIS;
                ++n2;
            }
            by = this.buf[n2];
        }
        return this.errorJIS == 0 && bl4;
    }

    private boolean isUTF8(byte[] byArray, int n) {
        int n2 = 0;
        byte by = this.buf[n2];
        while (n2 < n) {
            if (this.isASCII(by)) {
                ++n2;
            } else if (this.is2byteUTF8(by) && n2 + 1 < n) {
                if (this.isPayloadUTF8(this.buf[n2 + 1])) {
                    n2 += 2;
                } else {
                    ++this.errorUTF8;
                    ++n2;
                }
            } else if (this.is3byteUTF8(by) && n2 + 2 < n) {
                if (this.isPayloadUTF8(this.buf[n2 + 1]) && this.isPayloadUTF8(this.buf[n2 + 2])) {
                    n2 += 3;
                } else {
                    ++this.errorUTF8;
                    ++n2;
                }
            } else if (this.is4byteUTF8(by) && n2 + 3 < n) {
                if (this.isPayloadUTF8(this.buf[n2 + 1]) && this.isPayloadUTF8(this.buf[n2 + 2]) && this.isPayloadUTF8(this.buf[n2 + 3])) {
                    n2 += 4;
                } else {
                    ++this.errorUTF8;
                    ++n2;
                }
            } else {
                ++this.errorUTF8;
                ++n2;
            }
            by = this.buf[n2];
        }
        return this.errorUTF8 == 0;
    }

    private boolean isLATIN1(byte[] byArray, int n) {
        int n2 = 0;
        byte by = this.buf[n2];
        while (n2 < n) {
            if (this.isASCII(by) || this.isLATIN1(by)) {
                ++n2;
            } else {
                ++n2;
                ++this.errorLATIN1;
            }
            by = this.buf[n2];
        }
        return this.errorLATIN1 == 0;
    }

    private boolean isSJIS(byte[] byArray, int n) {
        int n2 = 0;
        byte by = this.buf[n2];
        while (n2 < n) {
            if (this.isASCII(by) || this.isSJISkana(by)) {
                ++n2;
            } else if (this.isSJIS1st(by) && n2 + 1 < n) {
                if (this.isSJIS2nd(this.buf[n2 + 1])) {
                    n2 += 2;
                } else {
                    ++n2;
                    ++this.errorSJIS;
                }
            } else {
                ++n2;
                ++this.errorSJIS;
            }
            by = this.buf[n2];
        }
        return this.errorSJIS == 0;
    }

    private boolean isEUC(byte[] byArray, int n) {
        int n2 = 0;
        byte by = this.buf[n2];
        while (n2 < n) {
            if (this.isASCII(by)) {
                ++n2;
            } else if (this.isEUCkanji(by) && n2 + 1 < n) {
                if (this.isPayloadEUC(this.buf[n2 + 1])) {
                    n2 += 2;
                } else {
                    ++n2;
                    ++this.errorEUC;
                }
            } else if (this.isEUCkana(by) && n2 + 1 < n) {
                if (this.isKanaPayloadEUC(this.buf[n2 + 1])) {
                    n2 += 2;
                } else {
                    ++n2;
                    ++this.errorEUC;
                }
            } else if (this.isEUChojo(by) && n2 + 2 < n) {
                if (this.isPayloadEUC(this.buf[n2 + 1]) && this.isPayloadEUC(this.buf[n2 + 2])) {
                    n2 += 3;
                } else {
                    ++n2;
                    ++this.errorEUC;
                }
            } else if (this.isEUCKisyu(by) && n2 + 1 < n) {
                if (this.isPayloadEUC(this.buf[n2 + 1])) {
                    this.eucRemoveV.add(new Integer(n2));
                    n2 += 2;
                } else {
                    ++n2;
                    ++this.errorEUC;
                }
            } else {
                ++n2;
                ++this.errorEUC;
            }
            by = this.buf[n2];
        }
        return this.errorEUC == 0;
    }

    public String detect() throws IOException {
        this.length = 0;
        this.errorJIS = 0;
        this.errorUTF8 = 0;
        this.errorLATIN1 = 0;
        this.errorSJIS = 0;
        this.errorEUC = 0;
        int n = this.is.read(this.buf, this.length, this.buf.length - this.length);
        while (n > 0) {
            this.length += n;
            if (this.length == this.buf.length) {
                byte[] byArray = new byte[this.length + 8192];
                System.arraycopy(this.buf, 0, byArray, 0, this.length);
                this.buf = byArray;
            }
            n = this.is.read(this.buf, this.length, this.buf.length - this.length);
        }
        n = 0;
        if (this.isJIS(this.buf, this.length)) {
            n = 2;
            return this.toString(n);
        }
        if (this.isUTF8(this.buf, this.length)) {
            n = 4;
            return this.toString(n);
        }
        if (this.isSJIS(this.buf, this.length)) {
            n = 0;
            return this.toString(n);
        }
        if (this.isEUC(this.buf, this.length)) {
            n = 1;
            this.removeKisyuIzonEUC();
            return this.toString(n);
        }
        if (this.isLATIN1(this.buf, this.length)) {
            n = 5;
            return this.toString(n);
        }
        n = 4;
        if (this.errorSJIS < 100 && this.errorSJIS < this.errorEUC && this.errorSJIS < this.errorUTF8 && this.errorSJIS < this.errorLATIN1 && this.errorSJIS < this.errorJIS) {
            n = 0;
        } else if (this.errorEUC < 100 && this.errorEUC < this.errorSJIS && this.errorEUC < this.errorUTF8 && this.errorEUC < this.errorLATIN1 && this.errorEUC < this.errorJIS) {
            this.removeKisyuIzonEUC();
            n = 1;
        } else if (this.errorLATIN1 < 100 && this.errorLATIN1 < this.errorSJIS && this.errorLATIN1 < this.errorEUC && this.errorLATIN1 < this.errorUTF8 && this.errorLATIN1 < this.errorJIS) {
            n = 5;
        } else if (this.errorJIS < 100 && this.errorJIS < this.errorSJIS && this.errorJIS < this.errorEUC && this.errorJIS < this.errorUTF8 && this.errorJIS < this.errorLATIN1) {
            n = 2;
        }
        return this.toString(n);
    }

    private boolean isPayloadJISkanji(byte by) {
        return 33 <= by && by <= 126;
    }

    private boolean isPayloadJISkana(byte by) {
        return 33 <= by && by <= 95;
    }

    private boolean isEUCkana(byte by) {
        return by == -114;
    }

    private boolean isEUCkanji(byte by) {
        return -95 <= by && by <= -2;
    }

    private boolean isEUChojo(byte by) {
        return by == -113;
    }

    private boolean isEUCKisyu(byte by) {
        return by == -96;
    }

    private boolean isEUC1st(byte by) {
        return by == -114 || by == -113 || -95 <= by && by <= -2;
    }

    private boolean isPayloadEUC(byte by) {
        return -96 <= by && by <= -1;
    }

    private boolean isKanaPayloadEUC(byte by) {
        return -95 <= by && by <= -33;
    }

    private boolean isSJIS1st(byte by) {
        return -127 <= by && by <= -97 || -32 <= by && by <= -17;
    }

    private boolean isSJISkana(byte by) {
        return -95 <= by && by <= -33;
    }

    private boolean isSJIS2nd(byte by) {
        return 64 <= by && by <= 126 || -128 <= by && by <= -4;
    }

    private boolean isASCII(byte by) {
        return by >= 0 && by <= 127;
    }

    private boolean isLATIN1(byte by) {
        return -96 <= by && by <= -1;
    }

    private boolean is2byteUTF8(byte by) {
        return -64 <= by && by <= -33;
    }

    private boolean is3byteUTF8(byte by) {
        return -32 <= by && by <= -17;
    }

    private boolean is4byteUTF8(byte by) {
        return -16 <= by && by <= -9;
    }

    private boolean isPayloadUTF8(byte by) {
        return -128 <= by && by <= -65;
    }
}

