/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;

public class WindowUtil {
    public static final int HWND_TOP = 0;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int HWND_BOTTOM = 1;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_COLORKEY = 1;
    public static final int LWA_ALPHA = 2;

    static {
        try {
            System.loadLibrary("AccessibiltyWin32Library");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String GetWindowText(int n) {
        int n2 = OS.GetWindowTextLength((int)n);
        if (n2 == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(0, n2 + 1);
        return tCHAR.toString(0, OS.GetWindowText((int)n, (TCHAR)tCHAR, (int)tCHAR.length()));
    }

    public static String GetWindowClassName(int n) {
        TCHAR tCHAR = new TCHAR(0, 256);
        return tCHAR.toString(0, OS.GetClassName((int)n, (TCHAR)tCHAR, (int)tCHAR.length()));
    }

    public static Rectangle GetWindowRectangle(int n) {
        RECT rECT = new RECT();
        OS.GetWindowRect((int)n, (RECT)rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public static boolean IsWindowVisible(int n) {
        return OS.IsWindowVisible((int)n);
    }

    public static int GetDesktopWindow() {
        return OS.GetDesktopWindow();
    }

    public static int GetChildWindow(int n) {
        return OS.GetWindow((int)n, (int)5);
    }

    public static int GetNextWindow(int n) {
        return OS.GetWindow((int)n, (int)2);
    }

    public static int GetOwnerWindow(int n) {
        return OS.GetWindow((int)n, (int)4);
    }

    public static int GetParentWindow(int n) {
        return OS.GetParent((int)n);
    }

    public static boolean isPopupMenu(int n) {
        if ("#32768".equals(WindowUtil.GetWindowClassName(n))) {
            return WindowUtil.GetOwnerWindow(n) == 0;
        }
        return false;
    }

    public static int FindWindow(String string, String string2) {
        return OS.FindWindow((TCHAR)new TCHAR(0, string, true), (TCHAR)new TCHAR(0, string2, true));
    }

    public static boolean BringWindowToTop(int n) {
        return OS.BringWindowToTop((int)n);
    }

    public static boolean SetWindowPos(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return OS.SetWindowPos((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7);
    }

    protected static final native int SetLayeredWindowAttributes(int var0, int var1, char var2, int var3);
}

