/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.swt.internal.ole.win32.COM;

public class NativeStringAccess {
    private int pBSTRAddress = 0;
    private int[] hMem = new int[1];

    public NativeStringAccess() {
        this.pBSTRAddress = MemoryUtil.GlobalAlloc(4);
    }

    public void dispose() {
        if (this.hMem[0] != 0) {
            COM.SysFreeString((int)this.hMem[0]);
        }
        MemoryUtil.GlobalFree(this.pBSTRAddress);
    }

    public int getAddress() {
        return this.pBSTRAddress;
    }

    public String getString() {
        int n;
        MemoryUtil.MoveMemory(this.hMem, this.pBSTRAddress, 4);
        if (this.hMem[0] != 0 && (n = COM.SysStringByteLen((int)this.hMem[0])) > 0) {
            char[] cArray = new char[(n + 1) / 2];
            MemoryUtil.MoveMemory(cArray, this.hMem[0], n);
            return new String(cArray);
        }
        return null;
    }

    public void setString(String string) {
        MemoryUtil.MoveMemory(this.hMem, this.pBSTRAddress, 4);
        if (this.hMem[0] != 0) {
            COM.SysFreeString((int)this.hMem[0]);
        }
        char[] cArray = (String.valueOf(string) + "\u0000").toCharArray();
        int n = COM.SysAllocString((char[])cArray);
        COM.MoveMemory((int)this.pBSTRAddress, (int[])new int[]{n}, (int)4);
        MemoryUtil.MoveMemory(this.hMem, this.pBSTRAddress, 4);
    }
}

