/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RadarChart {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 100;
    private static final int IMAGE_WIDTH = 260;
    private static final int IMAGE_HEIGHT = 150;
    private static final Color IMAGE_BGCOLOR = Color.WHITE;
    private static final double CIRCLE_CENTER_X = 130.0;
    private static final double CIRCLE_CENTER_Y = 75.0;
    private static final Point2D CIRCLE_CENTER = new Point2D.Double(130.0, 75.0);
    private static final double CIRCLE_RADIUS = 40.0;
    private static final Color CIRCLE_COLOR = Color.BLACK;
    private static final Color BAR_COLOR = Color.BLACK;
    private static final Color POLYGON_COLOR = new Color(102, 102, 255);
    private static final Color NAMES_COLOR = Color.RED;
    private static final Font NAMES_FONT = new Font("Default", 0, 16);
    private static final FontRenderContext NAMES_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private static final int NAMES_MARGIN = 5;
    private BufferedImage bufImage;
    private Graphics2D g2d;
    private int numItems;
    private String[] names;
    private int[] values;
    private Point2D[] valueFullPoints;
    private double[] valueTheta;
    private Point2D[] valuePoints;
    private static final int NUM_GRAD = 4;
    private static final double GRAD_LENGTH = 5.0;
    private boolean smoothing = true;

    public RadarChart(String[] stringArray, int[] nArray) throws Exception {
        this.names = stringArray;
        this.values = nArray;
        this.numItems = this.values.length;
        if (this.numItems != this.names.length) {
            throw new Exception("The numbers of names and values are different with each other.");
        }
        if (this.numItems < 3) {
            throw new Exception("At least three items are needed.");
        }
        int n = 0;
        while (n < this.numItems) {
            if (this.isOutOfRange(this.values[n])) {
                throw new Exception("The " + n + "-th value is out of range: " + this.values[n]);
            }
            ++n;
        }
        this.createChart();
    }

    private boolean isOutOfRange(int n) {
        return n < 0 || 100 < n;
    }

    private Point2D calcPointPolar(double d, double d2, double d3, double d4) {
        double d5 = d + d3 * Math.cos(d4);
        double d6 = d2 - d3 * Math.sin(d4);
        return new Point2D.Double(d5, d6);
    }

    private Point2D calcPointPolar(Point2D point2D, double d, double d2) {
        return this.calcPointPolar(point2D.getX(), point2D.getY(), d, d2);
    }

    private void createChart() {
        this.makePoints();
        this.bufImage = new BufferedImage(260, 150, 1);
        this.g2d = this.bufImage.createGraphics();
        this.g2d.setBackground(IMAGE_BGCOLOR);
        if (this.smoothing) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Object object;
            BufferedImage bufferedImage = new BufferedImage(this.bufImage.getWidth() * 2, this.bufImage.getHeight() * 2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Point2D[] point2DArray = new Point2D[this.numItems];
            Point2D[] point2DArray2 = new Point2D[this.numItems];
            int n6 = 0;
            while (n6 < this.numItems) {
                object = this.valuePoints[n6];
                point2DArray[n6] = new Point2D.Double(((Point2D)object).getX() * 2.0, ((Point2D)object).getY() * 2.0);
                object = this.valueFullPoints[n6];
                point2DArray2[n6] = new Point2D.Double(((Point2D)object).getX() * 2.0, ((Point2D)object).getY() * 2.0);
                ++n6;
            }
            Point2D.Double double_ = new Point2D.Double(260.0, 150.0);
            this.fillBackground(bufferedImage, graphics2D, IMAGE_BGCOLOR);
            this.drawEllipse(graphics2D, CIRCLE_COLOR, double_, 80.0);
            this.fillPolygon(graphics2D, POLYGON_COLOR, BAR_COLOR, point2DArray);
            this.drawBars(graphics2D, BAR_COLOR, point2DArray2, double_);
            object = bufferedImage.copyData(null);
            DataBufferInt dataBufferInt = (DataBufferInt)((Raster)object).getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            WritableRaster writableRaster = this.bufImage.copyData(null);
            DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray2 = dataBufferInt2.getData();
            float[][] fArray = new float[151][261];
            float[][] fArray2 = new float[151][261];
            float[][] fArray3 = new float[151][261];
            int n7 = 0;
            while (n7 < 150) {
                n5 = 0;
                while (n5 < 260) {
                    n4 = 4 * n7 * 260 + n5 * 2;
                    n3 = nArray[n4];
                    int n8 = n3 >> 16 & 0xFF;
                    n2 = n3 >> 8 & 0xFF;
                    int n9 = n3 & 0xFF;
                    n = nArray[n4 + 1];
                    int n10 = n >> 16 & 0xFF;
                    int n11 = n >> 8 & 0xFF;
                    int n12 = n & 0xFF;
                    int n13 = nArray[n4 + 520];
                    int n14 = n13 >> 16 & 0xFF;
                    int n15 = n13 >> 8 & 0xFF;
                    int n16 = n13 & 0xFF;
                    int n17 = nArray[n4 + 520 + 1];
                    int n18 = n17 >> 16 & 0xFF;
                    int n19 = n17 >> 8 & 0xFF;
                    int n20 = n17 & 0xFF;
                    fArray[n7][n5] = (float)(n8 + n10 + n14 + n18) / 4.0f;
                    fArray2[n7][n5] = (float)(n2 + n11 + n15 + n19) / 4.0f;
                    fArray3[n7][n5] = (float)(n9 + n12 + n16 + n20) / 4.0f;
                    ++n5;
                }
                ++n7;
            }
            n7 = 0;
            n5 = 0;
            while (n5 < 150) {
                n4 = 0;
                while (n4 < 260) {
                    n3 = Math.round(fArray[n5][n4]);
                    if (n3 < 0) {
                        n3 = 0;
                    } else if (255 < n3) {
                        n3 = 255;
                    }
                    float f = fArray[n5][n4] - (float)n3;
                    float[] fArray4 = fArray[n5];
                    int n21 = n4 + 1;
                    fArray4[n21] = fArray4[n21] + f * 0.375f;
                    float[] fArray5 = fArray[n5 + 1];
                    int n22 = n4;
                    fArray5[n22] = fArray5[n22] + f * 0.375f;
                    float[] fArray6 = fArray[n5 + 1];
                    int n23 = n4 + 1;
                    fArray6[n23] = fArray6[n23] + f * 0.25f;
                    n2 = Math.round(fArray2[n5][n4]);
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (255 < n2) {
                        n2 = 255;
                    }
                    float f2 = fArray2[n5][n4] - (float)n2;
                    float[] fArray7 = fArray2[n5];
                    int n24 = n4 + 1;
                    fArray7[n24] = fArray7[n24] + f2 * 0.375f;
                    float[] fArray8 = fArray2[n5 + 1];
                    int n25 = n4;
                    fArray8[n25] = fArray8[n25] + f2 * 0.375f;
                    float[] fArray9 = fArray2[n5 + 1];
                    int n26 = n4 + 1;
                    fArray9[n26] = fArray9[n26] + f2 * 0.25f;
                    n = Math.round(fArray3[n5][n4]);
                    if (n < 0) {
                        n = 0;
                    } else if (255 < n) {
                        n = 255;
                    }
                    float f3 = fArray3[n5][n4] - (float)n;
                    float[] fArray10 = fArray3[n5];
                    int n27 = n4 + 1;
                    fArray10[n27] = fArray10[n27] + f3 * 0.375f;
                    float[] fArray11 = fArray3[n5 + 1];
                    int n28 = n4;
                    fArray11[n28] = fArray11[n28] + f3 * 0.375f;
                    float[] fArray12 = fArray3[n5 + 1];
                    int n29 = n4 + 1;
                    fArray12[n29] = fArray12[n29] + f3 * 0.25f;
                    nArray2[n7] = n3 << 16 | n2 << 8 | n;
                    ++n7;
                    ++n4;
                }
                ++n5;
            }
            this.bufImage.setData(writableRaster);
        } else {
            this.fillBackground(this.bufImage, this.g2d, IMAGE_BGCOLOR);
            this.drawEllipse(this.g2d, CIRCLE_COLOR, CIRCLE_CENTER, 40.0);
            this.fillPolygon(this.g2d, POLYGON_COLOR, BAR_COLOR, this.valuePoints);
            this.drawBars(this.g2d, BAR_COLOR, this.valueFullPoints, CIRCLE_CENTER);
        }
        this.drawNames(this.g2d, NAMES_COLOR);
    }

    private void makePoints() {
        this.valueFullPoints = new Point2D[this.numItems];
        this.valueTheta = new double[this.numItems];
        this.valuePoints = new Point2D[this.numItems];
        double d = Math.PI * 2 / (double)this.numItems;
        double d2 = 1.5707963267948966;
        int n = 0;
        while (n < this.numItems) {
            this.valueTheta[n] = d2 + (double)n * d;
            this.valueFullPoints[n] = this.calcPointPolar(130.0, 75.0, 40.0, this.valueTheta[n]);
            double d3 = (double)this.values[n] / 100.0;
            this.valuePoints[n] = new Point2D.Double(130.0 * (1.0 - d3) + this.valueFullPoints[n].getX() * d3, 75.0 * (1.0 - d3) + this.valueFullPoints[n].getY() * d3);
            ++n;
        }
    }

    private void fillBackground(BufferedImage bufferedImage, Graphics2D graphics2D, Color color) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.fill(double_);
        graphics2D.setPaint(paint);
    }

    private void drawEllipse(Graphics2D graphics2D, Color color, Point2D point2D, double d) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        double d2 = point2D.getX() - d;
        double d3 = point2D.getY() - d;
        double d4 = d * 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d2, d3, d4, d4);
        graphics2D.draw(double_);
        graphics2D.setPaint(paint);
    }

    private void fillPolygon(Graphics2D graphics2D, Color color, Color color2, Point2D[] point2DArray) {
        Paint paint = graphics2D.getPaint();
        int[] nArray = new int[this.numItems];
        int[] nArray2 = new int[this.numItems];
        int n = 0;
        while (n < this.numItems) {
            nArray[n] = (int)point2DArray[n].getX();
            nArray2[n] = (int)point2DArray[n].getY();
            ++n;
        }
        Polygon polygon = new Polygon(nArray, nArray2, this.numItems);
        graphics2D.setPaint(color);
        graphics2D.fill(polygon);
        graphics2D.setPaint(color2);
        Line2D.Double double_ = new Line2D.Double(point2DArray[this.numItems - 1], point2DArray[0]);
        graphics2D.draw(double_);
        int n2 = 0;
        while (n2 < this.numItems - 1) {
            double_ = new Line2D.Double(point2DArray[n2], point2DArray[n2 + 1]);
            graphics2D.draw(double_);
            ++n2;
        }
        graphics2D.setPaint(paint);
    }

    private void drawBars(Graphics2D graphics2D, Color color, Point2D[] point2DArray, Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        int n = 0;
        while (n < this.numItems) {
            double d3 = point2DArray[n].getX();
            double d4 = point2DArray[n].getY();
            Line2D.Double double_ = new Line2D.Double(d, d2, d3, d4);
            graphics2D.draw(double_);
            int n2 = 1;
            while (n2 < 4) {
                double d5 = (double)n2 / 4.0;
                Point2D.Double double_2 = new Point2D.Double(d * (1.0 - d5) + d3 * d5, d2 * (1.0 - d5) + d4 * d5);
                Point2D point2D2 = this.calcPointPolar(double_2, 5.0, this.valueTheta[n] + 1.5707963267948966);
                Point2D point2D3 = this.calcPointPolar(double_2, 5.0, this.valueTheta[n] - 1.5707963267948966);
                double_ = new Line2D.Double(point2D2, point2D3);
                graphics2D.draw(double_);
                ++n2;
            }
            ++n;
        }
        graphics2D.setPaint(paint);
    }

    private void drawNames(Graphics2D graphics2D, Color color) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.setFont(NAMES_FONT);
        int n = 0;
        while (n < this.numItems) {
            Rectangle2D rectangle2D = NAMES_FONT.getStringBounds(this.names[n], NAMES_FONT_RENDER_CONTEXT);
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            double d3 = this.valueFullPoints[n].getX();
            double d4 = this.valueFullPoints[n].getY();
            float f = 0.0f;
            float f2 = 0.0f;
            if (d3 < 130.0) {
                f = (float)(d3 - d - 5.0);
                f2 = (float)(d4 + d2 / 2.0);
            } else if (130.0 < d3) {
                f = (float)(d3 + 5.0);
                f2 = (float)(d4 + d2 / 2.0);
            } else {
                f = (float)(d3 - d / 2.0);
                f2 = d4 < 75.0 ? (float)(d4 - 5.0) : (float)(d4 + d2 + 5.0);
            }
            graphics2D.drawString(this.names[n], f, f2);
            ++n;
        }
        graphics2D.setPaint(paint);
    }

    public BufferedImage getBufferedImage() {
        return this.bufImage;
    }

    public void writeToPNG(File file) throws IOException {
        ImageIO.write((RenderedImage)this.bufImage, "PNG", file);
    }
}

