/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.util.StringTokenizer;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;

public class ColorCSS
extends ColorIRGB {
    private static final String DELIM = "/";
    static final int TRANSPARENT_R = 255;
    static final int TRANSPARENT_G = 255;
    static final int TRANSPARENT_B = 255;
    public static final int TRANSPARENT = 0xFFFFFF;
    public static final int DEFAULT_BACKGROUND_COLOR_INT = 0xFFFFFF;
    public static final int DEFAULT_COLOR_INT = 0;
    String originalString = "";

    public ColorCSS(String string) throws ColorException {
        this(string, true);
    }

    public ColorCSS(String string, boolean bl) throws ColorException {
        this.originalString = !string.endsWith(DELIM) ? string : string.substring(0, string.length() - 1);
        if (this.originalString.indexOf(DELIM) == -1) {
            ColorIRGB colorIRGB = new ColorIRGB(this.originalString);
            this.R = colorIRGB.getR();
            this.G = colorIRGB.getG();
            this.B = colorIRGB.getB();
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.originalString.toLowerCase(), DELIM);
            boolean bl2 = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("transparent")) continue;
                ColorIRGB colorIRGB = new ColorIRGB(string2);
                this.R = colorIRGB.getR();
                this.G = colorIRGB.getG();
                this.B = colorIRGB.getB();
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.R = 255;
                this.G = 255;
                this.B = 255;
            }
        }
        if (bl) {
            this.rangeCheck();
        } else {
            this.rangeAdjust();
        }
    }

    public ColorCSS() throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    public ColorCSS(int n) throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    public ColorCSS(int n, int n2, int n3) throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    public ColorCSS(int n, int n2, int n3, boolean bl) throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    private void rangeCheck() throws ColorException {
        if (this.R < 0 || this.R > 255) {
            throw new ColorException("R is out of range: " + this.R + ", inputString = " + this.originalString);
        }
        if (this.G < 0 || this.G > 255) {
            throw new ColorException("G is out of range: " + this.G + ", inputString = " + this.originalString);
        }
        if (this.B < 0 || this.B > 255) {
            throw new ColorException("B is out of range: " + this.B + ", inputString = " + this.originalString);
        }
    }

    private void rangeAdjust() {
        if (this.R < 0) {
            this.R = 0;
        } else if (this.R > 255) {
            this.R = 255;
        }
        if (this.G < 0) {
            this.G = 0;
        } else if (this.G > 255) {
            this.G = 255;
        }
        if (this.B < 0) {
            this.B = 0;
        } else if (this.B > 255) {
            this.B = 255;
        }
    }

    public String getOriginalString() {
        return this.originalString;
    }
}

