/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;

public class EdgeDetector {
    public static final short METHOD_LAPLACIAN4_MINUS = 0;
    public static final short METHOD_LAPLACIAN4_PLUS = 1;
    public static final short METHOD_LAPLACIAN8_MINUS = 2;
    public static final short METHOD_LAPLACIAN8_PLUS = 3;
    public static final short METHOD_DEFAULT = 0;
    private static final float[] LAPLACIAN4_3X3_MINUS = new float[]{0.0f, 1.0f, 0.0f, 1.0f, -4.0f, 1.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] LAPLACIAN4_3X3_PLUS = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    private static final float[] LAPLACIAN8_3X3_MINUS = new float[]{1.0f, 1.0f, 1.0f, 1.0f, -8.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] LAPLACIAN8_3X3_PLUS = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    private BufferedImage srcBufferedImage = null;
    private BufferedImage destBufferedImage = null;

    public EdgeDetector(BufferedImage bufferedImage) throws LowVisionException {
        this(bufferedImage, 0);
    }

    public EdgeDetector(BufferedImage bufferedImage, short s) throws LowVisionException {
        this.srcBufferedImage = bufferedImage;
        if (s == 0) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN4_3X3_MINUS);
        } else if (s == 1) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN4_3X3_PLUS);
        } else if (s == 2) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN8_3X3_MINUS);
        } else if (s == 3) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN8_3X3_PLUS);
        } else {
            throw new LowVisionException("Unknown method: " + s);
        }
    }

    private BufferedImage convolve(BufferedImage bufferedImage, int n, int n2, float[] fArray) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Kernel kernel = new Kernel(n, n2, fArray);
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
        return convolveOp.filter(bufferedImage, bufferedImage2);
    }

    public BufferedImage writeToImage() {
        return this.destBufferedImage;
    }
}

