/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceData;

public class ClasspathUpdater {
    private final WorkspaceData wsData;
    private Predicate<IProject> predicate;
    private Map<String, IPath> sourcePaths;

    public ClasspathUpdater(WorkspaceData wsData) {
        this.wsData = wsData;
    }

    public void setPredicate(Predicate<IProject> predicate) {
        this.predicate = predicate;
    }

    public void setSourcePaths(Map<String, IPath> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void update(TaskingLog console, IProgressMonitor monitor) {
        console.info("running class-path update");
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor updMon = mon.newChild(70);
        updMon.beginTask("Update classpaths...", this.wsData.getPlugins().size());
        ArrayList<PluginData> refreshList = new ArrayList<PluginData>();
        for (PluginData pd : this.wsData.getPlugins()) {
            updMon.worked(1);
            String bundleName = pd.getBundleName();
            try {
                IProject project = pd.getProject();
                if (project == null) {
                    console.warn("skipping " + bundleName);
                    continue;
                }
                if (this.predicate != null && !this.predicate.test(project)) continue;
                IPluginModelBase model = PluginRegistry.findModel((IProject)project);
                if (model == null) {
                    console.warn("skipping " + bundleName);
                    continue;
                }
                IClasspathEntry[] entries = ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, null, (boolean)false, (boolean)true);
                ArrayList<IClasspathEntry> processed = new ArrayList<IClasspathEntry>();
                IClasspathEntry[] iClasspathEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry e = iClasspathEntryArray[n2];
                    if (this.sourcePaths != null && !this.sourcePaths.isEmpty() && e.getEntryKind() == 1 && e.getSourceAttachmentPath() == null && this.sourcePaths.containsKey(e.getPath().lastSegment())) {
                        processed.add(JavaCore.newLibraryEntry((IPath)e.getPath(), (IPath)this.sourcePaths.get(e.getPath().lastSegment()), null, (IAccessRule[])e.getAccessRules(), (IClasspathAttribute[])e.getExtraAttributes(), (boolean)e.isExported()));
                    } else {
                        processed.add(e);
                    }
                    ++n2;
                }
                JavaCore.create((IProject)project).setRawClasspath(processed.toArray(new IClasspathEntry[processed.size()]), null);
                refreshList.add(pd);
            }
            catch (Exception ex) {
                console.error("cannot update " + bundleName + ": " + ex);
                ex.printStackTrace(console.warn());
            }
        }
        console.debug("refreshing " + refreshList.size() + " bundles");
        SubMonitor refMon = mon.newChild(30);
        refMon.beginTask("Refreshing plugins...", refreshList.size());
        for (PluginData pd : refreshList) {
            refMon.worked(1);
            pd.refreshProject();
        }
        console.info("update finished");
        if (monitor != null) {
            monitor.done();
        }
    }
}

