/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.resources.BasicWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.xtend.typesystem.emf.SphinxManagedEmfMetaModel;
import org.eclipse.sphinx.xtendxpand.XtendEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.jobs.SaveAsNewFileHandler;
import org.eclipse.sphinx.xtendxpand.jobs.XtendJob;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.jobs.ResultMessageHandler;
import org.eclipse.sphinx.xtendxpand.ui.wizards.M2MConfigurationWizard;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.xtend.shared.ui.MetamodelContributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.typesystem.MetaModel;

public class BasicM2MAction
extends BaseSelectionListenerAction {
    public static final String DEFAULT_FUNCTION_NAME = "transform";
    private IWorkspaceResourceLoader workspaceResourceLoader;

    public BasicM2MAction(String text) {
        super(text);
    }

    protected EObject getSelectedModelObject() {
        Object selected = this.getStructuredSelection().getFirstElement();
        if (selected instanceof EObject) {
            return (EObject)selected;
        }
        Resource resource = EcorePlatformUtil.getResource((Object)selected);
        if (resource != null && !resource.getContents().isEmpty()) {
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1 && this.getSelectedModelObject() != null;
    }

    public void run() {
        EObject modelObject = this.getSelectedModelObject();
        if (this.getExtensionName(modelObject) != null) {
            IJobChangeListener resultMessageHandler;
            ExtendedPlatformUI.showSystemConsole();
            XtendJob job = this.createXtendJob();
            job.setPriority(40);
            IJobChangeListener resultObjectHandler = this.createResultObjectHandler();
            if (resultObjectHandler != null) {
                job.addJobChangeListener(resultObjectHandler);
            }
            if ((resultMessageHandler = this.createResultMessageHandler()) != null) {
                job.addJobChangeListener(resultMessageHandler);
            }
            job.schedule();
        } else {
            M2MConfigurationWizard wizard = new M2MConfigurationWizard(modelObject, this.getMetaModels());
            wizard.setM2MJobName(this.getM2MJobName());
            wizard.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
            wizard.setResultObjectHandler(this.createResultObjectHandler());
            wizard.setResultMessageHandler(this.createResultMessageHandler());
            WizardDialog wizardDialog = new WizardDialog(ExtendedPlatformUI.getDisplay().getActiveShell(), (IWizard)wizard);
            wizardDialog.open();
        }
    }

    protected XtendJob createXtendJob() {
        XtendJob job = new XtendJob(this.getM2MJobName(), this.getMetaModels(), this.getXtendEvaluationRequests());
        job.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        job.setPriority(40);
        job.setRule((ISchedulingRule)EcorePlatformUtil.getFile((EObject)this.getSelectedModelObject()).getProject());
        return job;
    }

    protected String getM2MJobName() {
        return Messages.job_transformingModel;
    }

    protected IJobChangeListener createResultObjectHandler() {
        return new SaveAsNewFileHandler();
    }

    protected IJobChangeListener createResultMessageHandler() {
        return new ResultMessageHandler();
    }

    protected List<MetaModel> getMetaModels() {
        ArrayList<Object> metaModels = new ArrayList<Object>();
        IFile file = EcorePlatformUtil.getFile((EObject)this.getSelectedModelObject());
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        List contributors = MetamodelContributorRegistry.getActiveMetamodelContributors((IJavaProject)javaProject);
        for (MetamodelContributor contributor : contributors) {
            metaModels.addAll(Arrays.asList(contributor.getMetamodels(javaProject, null)));
        }
        if (metaModels.isEmpty()) {
            IModelDescriptor model = ModelDescriptorRegistry.INSTANCE.getModel(file);
            metaModels.add(new SphinxManagedEmfMetaModel(model));
        }
        return Collections.unmodifiableList(metaModels);
    }

    protected Collection<XtendEvaluationRequest> getXtendEvaluationRequests() {
        EObject selected = this.getSelectedModelObject();
        String extensionName = this.getExtensionName(selected);
        if (extensionName != null && selected != null) {
            XtendEvaluationRequest request = new XtendEvaluationRequest(extensionName, (Object)selected);
            return Collections.singletonList(request);
        }
        return Collections.emptyList();
    }

    protected String getExtensionName(EObject modelObject) {
        IFile extensionFile = this.getExtensionFile(modelObject);
        if (extensionFile != null) {
            return XtendXpandUtil.getQualifiedName((IFile)extensionFile, (String)this.getFunctionName());
        }
        return null;
    }

    protected IFile getExtensionFile(EObject modelObject) {
        IFile modelFile = EcorePlatformUtil.getFile((EObject)modelObject);
        if (modelFile != null) {
            IPath templatePath = modelFile.getFullPath().removeFileExtension().addFileExtension("ext");
            return ResourcesPlugin.getWorkspace().getRoot().getFile(templatePath);
        }
        return null;
    }

    protected String getFunctionName() {
        return DEFAULT_FUNCTION_NAME;
    }

    protected IWorkspaceResourceLoader getWorkspaceResourceLoader() {
        if (this.workspaceResourceLoader == null) {
            this.workspaceResourceLoader = this.createWorkspaceResourceLoader();
        }
        return this.workspaceResourceLoader;
    }

    protected IWorkspaceResourceLoader createWorkspaceResourceLoader() {
        return new BasicWorkspaceResourceLoader();
    }
}

