/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.validation.Activator;
import org.eclipse.sphinx.emf.validation.diagnostic.ExtendedDiagnostician;
import org.eclipse.sphinx.emf.validation.internal.messages.Messages;
import org.eclipse.sphinx.emf.validation.markers.ValidationMarkerManager;
import org.eclipse.sphinx.emf.validation.stats.ValidationPerformanceStats;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ValidationUtil {
    public static String getSegment(String uri) {
        int lowerBound = uri.lastIndexOf("#");
        int upperBound = uri.lastIndexOf("?");
        if (lowerBound != -1 && upperBound != -1) {
            return uri.substring(lowerBound + 1, upperBound);
        }
        return "";
    }

    public static String getObjectId(String uri) {
        int lowerBound = uri.lastIndexOf("/");
        int upperBound = uri.lastIndexOf("?");
        if (lowerBound != -1 && upperBound != -1) {
            return uri.substring(lowerBound + 1, upperBound);
        }
        return "";
    }

    public static String[] splitURI(EObject eObject) {
        URI uri = ValidationUtil.getURI(eObject);
        return ValidationUtil.splitURI(uri);
    }

    protected static URI getURI(final EObject eObject) {
        TransactionalEditingDomain editingDomain;
        if (eObject != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)eObject)) != null) {
            try {
                return (URI)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<URI>(){

                    public void run() {
                        this.setResult(EcoreUtil.getURI((EObject)eObject));
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
        return null;
    }

    public static String[] splitURI(URI uri) {
        return uri == null ? null : ValidationUtil.splitURI(uri.toString());
    }

    public static String[] splitURI(String uri) {
        return uri == null ? null : uri.split("\\?");
    }

    public static String computeOldURI(EObject eObject, String oldName) {
        if (oldName == null) {
            return null;
        }
        URI uri_ = ValidationUtil.getURI(eObject);
        if (uri_ == null || uri_.segmentCount() < 1) {
            return null;
        }
        String uri = uri_.toString();
        int lowerBound = uri.lastIndexOf("/");
        int upperBound = uri.lastIndexOf("?");
        String newName = uri.substring(lowerBound, upperBound);
        return uri.replace(String.valueOf(newName) + "?", "/" + oldName + "?");
    }

    public static String getObjectType(String uri) {
        return uri.substring(uri.lastIndexOf("=") + 1);
    }

    private static List<EObject> getModelObjects(Collection<?> objects) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Object obj : objects) {
            Object object;
            if (obj instanceof IProject) {
                IProject project = (IProject)obj;
                if (!project.isAccessible()) continue;
                files.addAll(ExtendedPlatform.getAllFiles((IProject)((IProject)obj), (boolean)true));
                continue;
            }
            if (obj instanceof IFolder) {
                IFolder folder = (IFolder)obj;
                if (!folder.isAccessible()) continue;
                files.addAll(ExtendedPlatform.getAllFiles((IFolder)((IFolder)obj)));
                continue;
            }
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                if (!file.isAccessible()) continue;
                files.add((IFile)obj);
                continue;
            }
            if (obj instanceof EObject) {
                result.add((EObject)obj);
                continue;
            }
            if (!(obj instanceof IWrapperItemProvider) || !((object = AdapterFactoryEditingDomain.unwrap(obj)) instanceof EObject)) continue;
            result.add((EObject)object);
        }
        if (!files.isEmpty()) {
            for (IFile file : files) {
                Resource resource = EcorePlatformUtil.getResource((IFile)file);
                if (resource == null) continue;
                result.addAll((Collection<EObject>)resource.getContents());
            }
        }
        return result;
    }

    private static int getNumberOfObject(EObject eObject) {
        int count = 0;
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    public static void validate(Collection<?> objects, Collection<IConstraintFilter> filters, IProgressMonitor monitor) {
        List<EObject> modelObjects = ValidationUtil.getModelObjects(objects);
        if (!modelObjects.isEmpty()) {
            ValidationPerformanceStats.INSTANCE.openContext("Validation of " + modelObjects.get(0));
            List<Diagnostic> diagnostics = ValidationUtil.validate(modelObjects, filters, monitor);
            ValidationUtil.handleDiagnostics(modelObjects, diagnostics);
        }
        ValidationPerformanceStats.INSTANCE.closeAndLogCurrentContext();
        monitor.done();
    }

    private static List<Diagnostic> validate(List<EObject> modelObjects, Collection<IConstraintFilter> filters, IProgressMonitor monitor) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        ExtendedDiagnostician diagnostician = new ExtendedDiagnostician();
        if (modelObjects.size() == 1) {
            EObject eObject = modelObjects.get(0);
            if (eObject != null) {
                int count = ValidationUtil.getNumberOfObject(eObject);
                monitor.beginTask(new String(), count);
                monitor.setTaskName(NLS.bind((String)Messages.task_subtask_validatingObject, (Object)diagnostician.getObjectLabel(eObject)));
                ValidationPerformanceStats.INSTANCE.startNewEvent(ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, eObject.toString());
                diagnostician.setProgressMonitor(monitor);
                result.add(diagnostician.validate(eObject, new HashSet<IConstraintFilter>(filters)));
                ValidationPerformanceStats.INSTANCE.endEvent(ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, eObject.toString());
                diagnostician.setProgressMonitor(null);
                monitor.done();
            }
            return result;
        }
        if (modelObjects.size() > 1) {
            int count = 0;
            int[] subCount = new int[modelObjects.size()];
            int cptObject = 0;
            for (EObject object : modelObjects) {
                subCount[cptObject] = ValidationUtil.getNumberOfObject(object);
                count += subCount[cptObject++];
            }
            monitor.beginTask(new String(), count);
            monitor.setTaskName(Messages.task_progressBar_InitialMsg);
            boolean isProgressMonitor = false;
            diagnostician.setProgressMonitor(monitor);
            isProgressMonitor = true;
            Diagnostic diag = null;
            cptObject = 0;
            int[] nbE = new int[3];
            for (EObject current : modelObjects) {
                if (monitor.isCanceled()) break;
                SubProgressMonitor subMonitor = null;
                if (isProgressMonitor) {
                    subMonitor = new SubProgressMonitor(monitor, subCount[cptObject++]);
                    subMonitor.subTask(NLS.bind((String)Messages.task_subtask_validatingFile, (Object)EcorePlatformUtil.getFile((EObject)current).getName()));
                }
                ValidationPerformanceStats.INSTANCE.startNewEvent(ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, current.toString());
                diag = diagnostician.validate(current);
                if (diag != null) {
                    result.add(diag);
                    for (Diagnostic c : diag.getChildren()) {
                        switch (c.getSeverity()) {
                            case 4: {
                                nbE[0] = nbE[0] + 1;
                                break;
                            }
                            case 2: {
                                nbE[1] = nbE[1] + 1;
                                break;
                            }
                            case 1: {
                                nbE[2] = nbE[2] + 1;
                            }
                        }
                    }
                }
                if (subMonitor != null) {
                    subMonitor.done();
                }
                ValidationPerformanceStats.INSTANCE.endEvent(ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, current.toString());
                monitor.setTaskName(NLS.bind((String)Messages.task_progressBar_ErrWarnInfo, (Object[])new Object[]{nbE[0], nbE[1], nbE[2]}));
            }
            diagnostician.setProgressMonitor(null);
            monitor.done();
            return result;
        }
        PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)new RuntimeException("Cannot perform validation on empty element selection."));
        return null;
    }

    private static void handleDiagnostics(List<EObject> selectedModelObjects, final List<Diagnostic> diagnostics) {
        if (diagnostics == null) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(Messages.job_HandlingDiagnostics){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                String blameObject = "UpdateMarkers";
                ValidationPerformanceStats.INSTANCE.startNewEvent(ValidationPerformanceStats.ValidationEvent.EVENT_UPDATE_PROBLEM_MARKERS, blameObject);
                ValidationMarkerManager markerManager = ValidationMarkerManager.getInstance();
                for (Diagnostic diag : diagnostics) {
                    markerManager.handleDiagnostic(diag);
                }
                ValidationPerformanceStats.INSTANCE.endEvent(ValidationPerformanceStats.ValidationEvent.EVENT_UPDATE_PROBLEM_MARKERS, blameObject);
                return Status.OK_STATUS;
            }
        };
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>();
        for (EObject eObject : selectedModelObjects) {
            IFile r = EcorePlatformUtil.getFile((EObject)eObject);
            if (r == null) continue;
            IResourceRuleFactory ruleFactory = r.getWorkspace().getRuleFactory();
            myRules.add(ruleFactory.modifyRule((IResource)r));
            myRules.add(ruleFactory.createRule((IResource)r));
        }
        job.setRule((ISchedulingRule)new MultiRule(myRules.toArray(new ISchedulingRule[myRules.size()])));
        job.setPriority(40);
        job.schedule();
    }
}

