/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.markers.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.validation.constraint.IExtendedConstraintDescriptor;
import org.eclipse.sphinx.emf.validation.util.ConstraintExtensionUtil;

public class FeatureAttUtil {
    private static String separator = "::";

    public static void packFeatures(IMarker marker, Set<String> features) throws CoreException {
        Assert.isNotNull((Object)marker);
        Assert.isNotNull(features);
        if (features.size() < 1) {
            return;
        }
        String res = "";
        for (String feature : features) {
            res = String.valueOf(res) + feature + separator;
        }
        marker.setAttribute("features_id", (Object)res.substring(0, res.length() - 2));
    }

    public static String packFeaturesAsString(IMarker marker, Set<String> features) throws CoreException {
        Assert.isNotNull((Object)marker);
        Assert.isNotNull(features);
        if (features.size() < 1) {
            return null;
        }
        String res = "";
        for (String feature : features) {
            res = String.valueOf(res) + feature + separator;
        }
        return res.substring(0, res.length() - 2);
    }

    public static Set<String> unpackFeatures(IMarker marker) throws CoreException {
        Assert.isNotNull((Object)marker);
        Object obj = marker.getAttribute("features_id");
        HashSet<String> result = new HashSet<String>();
        if (obj != null && obj instanceof String) {
            String[] stringArray = ((String)obj).split(separator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String feature = stringArray[n2];
                result.add(feature);
                ++n2;
            }
        }
        return result;
    }

    public static Set<String> getRulesFeaturesForEObj(String ruleId, EObject eObject) {
        HashSet<String> result = new HashSet<String>();
        IConstraintDescriptor icd = ConstraintRegistry.getInstance().getDescriptor(ruleId);
        if (icd != null && icd instanceof IExtendedConstraintDescriptor) {
            String[] stringArray = ((IExtendedConstraintDescriptor)icd).getFeatures();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String current = stringArray[n2];
                result.add(current);
                ++n2;
            }
            return result;
        }
        Map<String, Set<String>> kf = ConstraintExtensionUtil.getRulesFeatures(ruleId);
        for (String key : kf.keySet()) {
            if (!EObjectUtil.isAssignableFrom((EClass)eObject.eClass(), (String)key)) continue;
            result.addAll((Collection<String>)kf.get(key));
        }
        return result;
    }
}

