/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class TransactionalDelegatingTreeContentProvider
implements ITreeContentProvider {
    private final TransactionalEditingDomain domain;
    private final ITreeContentProvider treeContentProvider;

    public TransactionalDelegatingTreeContentProvider(ITreeContentProvider treeContentProvider, TransactionalEditingDomain domain) {
        Assert.isNotNull((Object)treeContentProvider);
        Assert.isNotNull((Object)domain);
        this.treeContentProvider = treeContentProvider;
        this.domain = domain;
    }

    protected <T> T run(RunnableWithResult<? extends T> run) {
        try {
            return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)this.domain, run);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            PlatformLogUtil.getLog((Plugin)Activator.getPlugin()).log((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), Messages.contentProviderInterrupted, (Throwable)e));
            return null;
        }
    }

    public Object[] getChildren(final Object object) {
        return (Object[])this.run((RunnableWithResult)new RunnableWithResult.Impl<Object[]>(){

            public void run() {
                this.setResult(TransactionalDelegatingTreeContentProvider.this.treeContentProvider.getChildren(object));
            }
        });
    }

    public Object[] getElements(final Object object) {
        return (Object[])this.run((RunnableWithResult)new RunnableWithResult.Impl<Object[]>(){

            public void run() {
                this.setResult(TransactionalDelegatingTreeContentProvider.this.treeContentProvider.getElements(object));
            }
        });
    }

    public Object getParent(final Object object) {
        return this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                this.setResult(TransactionalDelegatingTreeContentProvider.this.treeContentProvider.getParent(object));
            }
        });
    }

    public boolean hasChildren(final Object object) {
        return (Boolean)this.run((RunnableWithResult)new RunnableWithResult.Impl<Boolean>(){

            public void run() {
                this.setResult(TransactionalDelegatingTreeContentProvider.this.treeContentProvider.hasChildren(object));
            }
        });
    }

    public void inputChanged(final Viewer vwr, final Object oldInput, final Object newInput) {
        this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                TransactionalDelegatingTreeContentProvider.this.treeContentProvider.inputChanged(vwr, oldInput, newInput);
            }
        });
    }

    public void dispose() {
        this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                TransactionalDelegatingTreeContentProvider.this.treeContentProvider.dispose();
            }
        });
    }
}

