/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.viewer.content;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.TypedElementWrapper;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeContentProvider;

public class ModelElementContentMergeContentProvider
extends ModelContentMergeContentProvider {
    public ModelElementContentMergeContentProvider(CompareConfiguration compareConfig) {
        super(compareConfig);
    }

    public Object getAncestorContent(Object element) {
        Object ancestorElement = null;
        if (element instanceof ModelCompareInput) {
            ModelCompareInput input = (ModelCompareInput)element;
            Object ancestorContentFromMatch = this.getAncestorContentFromMatch(input);
            if (ancestorContentFromMatch != null) {
                return ancestorContentFromMatch;
            }
            Object ancestorContentFromDiff = this.getAncestorContentFromDiff(input);
            if (ancestorContentFromDiff != null) {
                return ancestorContentFromDiff;
            }
            ITypedElement ancestor = input.getAncestor();
            ancestorElement = ancestor instanceof TypedElementWrapper ? ((TypedElementWrapper)ancestor).getObject() : ancestor;
        } else if (element instanceof ICompareInput) {
            ancestorElement = ((ICompareInput)element).getAncestor();
        }
        return ancestorElement;
    }

    public Object getLeftContent(Object element) {
        Object leftElement = null;
        if (element instanceof ModelCompareInput) {
            ModelCompareInput input = (ModelCompareInput)element;
            Object leftContentFromMatch = this.getLeftContentFromMatch(input);
            if (leftContentFromMatch != null) {
                return leftContentFromMatch;
            }
            Object leftContentFromDiff = this.getLeftContentFromDiff(input);
            if (leftContentFromDiff != null) {
                return leftContentFromDiff;
            }
            ITypedElement left = input.getLeft();
            leftElement = left instanceof TypedElementWrapper ? ((TypedElementWrapper)left).getObject() : left;
        } else if (element instanceof ICompareInput) {
            leftElement = ((ICompareInput)element).getLeft();
        }
        return leftElement;
    }

    public Object getRightContent(Object element) {
        Object rightElement = null;
        if (element instanceof ModelCompareInput) {
            ModelCompareInput input = (ModelCompareInput)element;
            Object rightContentFromMatch = this.getRightContentFromMatch(input);
            if (rightContentFromMatch != null) {
                return rightContentFromMatch;
            }
            Object rightContentFromDiff = this.getRightContentFromDiff(input);
            if (rightContentFromDiff != null) {
                return rightContentFromDiff;
            }
            ITypedElement right = input.getRight();
            rightElement = right instanceof TypedElementWrapper ? ((TypedElementWrapper)right).getObject() : right;
        } else if (element instanceof ICompareInput) {
            rightElement = ((ICompareInput)element).getRight();
        }
        return rightElement;
    }

    protected Object getLeftContentFromMatch(ModelCompareInput input) {
        MatchModel matchModel;
        Object match = input.getMatch();
        if (match instanceof MatchModel && (matchModel = (MatchModel)match).getLeftRoots() != null && !matchModel.getLeftRoots().isEmpty()) {
            return matchModel.getLeftRoots().get(0);
        }
        return null;
    }

    protected Object getLeftContentFromDiff(ModelCompareInput input) {
        DiffModel diffModel;
        Object diff = input.getDiff();
        if (diff instanceof DiffModel && (diffModel = (DiffModel)diff).getLeftRoots() != null && !diffModel.getLeftRoots().isEmpty()) {
            return diffModel.getLeftRoots().get(0);
        }
        return null;
    }

    protected Object getRightContentFromMatch(ModelCompareInput input) {
        MatchModel matchModel;
        Object match = input.getMatch();
        if (match instanceof MatchModel && (matchModel = (MatchModel)match).getRightRoots() != null && !matchModel.getRightRoots().isEmpty()) {
            return matchModel.getRightRoots().get(0);
        }
        return null;
    }

    protected Object getRightContentFromDiff(ModelCompareInput input) {
        DiffModel diffModel;
        Object diff = input.getDiff();
        if (diff instanceof DiffModel && (diffModel = (DiffModel)diff).getRightRoots() != null && !diffModel.getRightRoots().isEmpty()) {
            return diffModel.getRightRoots().get(0);
        }
        return null;
    }

    protected Object getAncestorContentFromMatch(ModelCompareInput input) {
        MatchModel matchModel;
        Object match = input.getMatch();
        if (match instanceof MatchModel && (matchModel = (MatchModel)match).getAncestorRoots() != null && !matchModel.getAncestorRoots().isEmpty()) {
            return matchModel.getAncestorRoots().get(0);
        }
        return null;
    }

    protected Object getAncestorContentFromDiff(ModelCompareInput input) {
        DiffModel diffModel;
        Object diff = input.getDiff();
        if (diff instanceof DiffModel && (diffModel = (DiffModel)diff).getAncestorRoots() != null && !diffModel.getAncestorRoots().isEmpty()) {
            return diffModel.getAncestorRoots().get(0);
        }
        return null;
    }
}

