/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.ICheckValidator;

public class CheckValidationUtil {
    public static Collection<Method> getDeclaredCheckMethods(Class<? extends ICheckValidator> validatorType) {
        Assert.isNotNull(validatorType);
        HashSet visitedValidatorTypes = new HashSet();
        ArrayList<Method> result = new ArrayList<Method>();
        CheckValidationUtil.collectDeclaredCheckMethods(validatorType, visitedValidatorTypes, result);
        return result;
    }

    private static void collectDeclaredCheckMethods(Class<? extends ICheckValidator> validatorType, Collection<Class<?>> visitedValidatorTypes, Collection<Method> result) {
        Method[] methods;
        if (!visitedValidatorTypes.add(validatorType)) {
            return;
        }
        Method[] methodArray = methods = validatorType.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Check annotation = method.getAnnotation(Check.class);
            if (annotation != null && method.getParameterTypes().length == 1) {
                result.add(method);
            }
            ++n2;
        }
        Class<? extends ICheckValidator> superClass = validatorType.getSuperclass();
        if (superClass != null && ICheckValidator.class.isAssignableFrom(superClass)) {
            CheckValidationUtil.collectDeclaredCheckMethods(superClass, visitedValidatorTypes, result);
        }
    }
}

