/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.metamodel.services.DefaultMetaModelServiceProvider;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.ModelSearchResult;
import org.eclipse.sphinx.emf.search.ui.QuerySpecification;
import org.eclipse.sphinx.emf.search.ui.internal.Activator;
import org.eclipse.sphinx.emf.search.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.search.ui.services.IModelSearchService;

public class ModelSearchQuery
implements ISearchQuery {
    private ISearchResult searchResult;
    private QuerySpecification querySpecification;

    public ModelSearchQuery(QuerySpecification querySpec) {
        this.querySpecification = querySpec;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        ModelSearchResult result = (ModelSearchResult)this.getSearchResult();
        List<ModelSearchMatch> matches = this.performSearch();
        if (!matches.isEmpty()) {
            if (matches.size() == 1) {
                result.addMatch(matches.get(0));
            } else {
                result.addMatches(matches.toArray(new ModelSearchMatch[matches.size()]));
            }
        }
        String message = NLS.bind((String)Messages.ModelSearchQuery_status_ok_message, (Object)String.valueOf(result.getMatchCount()));
        return new Status(0, Activator.getDefault().getSymbolicName(), 0, message, null);
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (nMatches == 1) {
            Object[] args = new Object[]{searchString, "workspace"};
            return NLS.bind((String)Messages.ModelSearchQuery_singularLabel, (Object[])args);
        }
        Object[] args = new Object[]{searchString, new Integer(nMatches), "workspace"};
        return NLS.bind((String)Messages.ModelSearchQuery_pluralPattern, (Object[])args);
    }

    private String getSearchString() {
        return this.querySpecification.getPattern();
    }

    private List<ModelSearchMatch> performSearch() {
        ArrayList<ModelSearchMatch> result = new ArrayList<ModelSearchMatch>();
        Set<IProject> projects = this.querySpecification.getProjects();
        for (IProject prj : projects) {
            Collection models = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)prj);
            for (IModelDescriptor modelDescriptor : models) {
                IMetaModelDescriptor metaModelDescriptor = modelDescriptor.getMetaModelDescriptor();
                IModelSearchService modelSearchService = this.getModelSearchService(metaModelDescriptor);
                if (modelSearchService == null) continue;
                result.addAll(modelSearchService.getMatches(modelDescriptor, this.querySpecification));
            }
        }
        return result;
    }

    protected IModelSearchService getModelSearchService(IMetaModelDescriptor descriptor) {
        IModelSearchService modelSearchService = null;
        if (descriptor != null) {
            modelSearchService = (IModelSearchService)new DefaultMetaModelServiceProvider().getService(descriptor, IModelSearchService.class);
        }
        if (modelSearchService == null) {
            modelSearchService = (IModelSearchService)new DefaultMetaModelServiceProvider().getService(MetaModelDescriptorRegistry.ANY_MM, IModelSearchService.class);
        }
        return modelSearchService;
    }

    public String getLabel() {
        return Messages.ModelSearchQuery_label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            ModelSearchResult result = new ModelSearchResult(this);
            this.searchResult = result;
        }
        return this.searchResult;
    }
}

