/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.AbstractTreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TreeElementStateProviderFactory;
import org.eclipse.sphinx.emf.workspace.util.ModelOperationRunner;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IMemento;

public class EObjectElementStateProvider
extends AbstractTreeElementStateProvider {
    private URI uri = null;
    private EObject eObject = null;

    public EObjectElementStateProvider(TreeViewer viewer, IMemento memento) {
        super(viewer);
        Assert.isNotNull((Object)memento);
        String uriAsString = memento.getString("uri");
        if (uriAsString != null) {
            this.uri = URI.createURI((String)uriAsString, (boolean)true);
        }
    }

    public EObjectElementStateProvider(TreeViewer viewer, URI uri) {
        super(viewer);
        this.uri = uri;
    }

    @Override
    public boolean hasUnderlyingModel() {
        return true;
    }

    @Override
    public boolean canUnderlyingModelBeLoaded() {
        return EcoreResourceUtil.exists((URI)this.uri);
    }

    @Override
    public boolean isUnderlyingModelLoaded() {
        final Resource resource = EcorePlatformUtil.getResource((URI)this.uri);
        if (resource != null) {
            try {
                RunnableWithResult.Impl<Boolean> runnable = new RunnableWithResult.Impl<Boolean>(){

                    public void run() {
                        ExtendedResource extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt(resource);
                        if (extendedResource != null) {
                            this.setResult(extendedResource.isFullyLoaded());
                        } else {
                            this.setResult(true);
                        }
                    }
                };
                ModelOperationRunner.performModelAccess((Resource)resource, (RunnableWithResult)runnable);
                return (Boolean)runnable.getResult();
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                return false;
            }
        }
        return false;
    }

    @Override
    public void loadUnderlyingModel() {
        IFile file = EcorePlatformUtil.getFile((URI)this.uri);
        IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(file);
        if (modelDescriptor != null) {
            ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
        }
    }

    @Override
    public boolean isStale() {
        return this.getTreeElement() == null;
    }

    @Override
    public Object getTreeElement() {
        if (this.eObject == null) {
            this.eObject = EcorePlatformUtil.getEObject((URI)this.uri);
        }
        return this.eObject;
    }

    @Override
    public void appendToMemento(IMemento parentMemento) {
        if (this.uri != null) {
            IMemento memento = parentMemento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_ELEMENT_EOBJECT);
            memento.putString("uri", this.uri.toString());
        }
    }

    public String toString() {
        return "EObjectElementProvider [uri=" + this.uri + ", eObject=" + this.eObject + "]";
    }
}

