/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.actions.providers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sphinx.emf.ui.actions.providers.BasicActionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class BasicModelUndoRedoActionProvider
extends BasicActionProvider {
    protected UndoAction undoAction;
    protected RedoAction redoAction;

    public void doInit() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = this.createUndoAction();
        Assert.isNotNull((Object)this.undoAction);
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.undoAction.setActiveWorkbenchPart(this.workbenchPart);
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = this.createRedoAction();
        Assert.isNotNull((Object)this.redoAction);
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.redoAction.setActiveWorkbenchPart(this.workbenchPart);
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.redoAction));
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.updateActions(this.getContext().getSelection());
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void updateActionBars() {
        super.updateActionBars();
        this.undoAction.update();
        this.redoAction.update();
    }

    public void dispose() {
        super.dispose();
        if (this.undoAction != null) {
            this.undoAction.setEditingDomain(null);
        }
        if (this.undoAction != null) {
            this.redoAction.setEditingDomain(null);
        }
    }

    protected void updateActions(ISelection selection) {
        TransactionalEditingDomain editingDomain = this.getEditingDomainFromSelection(selection);
        this.undoAction.setEditingDomain((EditingDomain)editingDomain);
        this.redoAction.setEditingDomain((EditingDomain)editingDomain);
    }

    protected RedoAction createRedoAction() {
        return new RedoActionWrapper();
    }

    protected UndoAction createUndoAction() {
        return new UndoActionWrapper();
    }
}

