/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.incquery.proxymanagment;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolver;
import org.eclipse.sphinx.emf.incquery.AbstractIncQueryProvider;
import org.eclipse.sphinx.emf.incquery.IIncQueryEngineHelper;
import org.eclipse.sphinx.emf.incquery.IncQueryEngineHelper;
import org.eclipse.sphinx.emf.incquery.internal.Activator;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSet;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractIncQueryProxyResolver
extends AbstractIncQueryProvider
implements IProxyResolver {
    private IIncQueryEngineHelper incQueryEngineHelper;

    protected IIncQueryEngineHelper getIncQueryEngineHelper() {
        if (this.incQueryEngineHelper == null) {
            this.incQueryEngineHelper = this.createIncQueryEngineHelper();
        }
        return this.incQueryEngineHelper;
    }

    protected IIncQueryEngineHelper createIncQueryEngineHelper() {
        return new IncQueryEngineHelper();
    }

    protected abstract EObject[] getEObjectCandidates(EObject var1, Object var2, IncQueryEngine var3);

    protected abstract EObject[] getEObjectCandidates(URI var1, Object var2, IncQueryEngine var3);

    protected EObject getMatchingEObject(URI uri, Object contextObject, EObject[] candidates) {
        if (uri != null && candidates != null) {
            EObject[] eObjectArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                EObject candidate = eObjectArray[n2];
                if (this.matchesEObjectCandidate(uri, contextObject, candidate)) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    protected boolean matchesEObjectCandidate(URI uri, Object contextObject, EObject candidate) {
        return this.matchesEObjectCandidate(uri, candidate);
    }

    protected boolean matchesEObjectCandidate(URI uri, EObject candidate) {
        URI candidateURI = EcoreResourceUtil.getURI((EObject)candidate);
        return uri.equals(candidateURI);
    }

    public boolean canResolve(EObject eObject) {
        if (eObject != null) {
            return this.canResolve(eObject.eClass());
        }
        return false;
    }

    public boolean canResolve(EClass eType) {
        if (eType != null) {
            return this.getSupportedTypes().contains(eType.getInstanceClass()) && !eType.isAbstract() && !eType.isInterface();
        }
        return false;
    }

    protected URI trimContextInfo(URI proxyURI, EObject contextObject) {
        ResourceSet contextResourceSet;
        Resource contextResource;
        if (contextObject != null && (contextResource = contextObject.eResource()) != null && (contextResourceSet = contextResource.getResourceSet()) instanceof ExtendedResourceSet) {
            return ((ExtendedResourceSet)contextResourceSet).trimProxyContextInfo(proxyURI);
        }
        return proxyURI;
    }

    public EObject getEObject(EObject proxy, EObject contextObject, boolean loadOnDemand) {
        try {
            if (proxy != null) {
                URI uri = this.trimContextInfo(((InternalEObject)proxy).eProxyURI(), contextObject);
                IncQueryEngine engine = this.getIncQueryEngineHelper().getEngine(contextObject);
                EObject[] candidates = this.getEObjectCandidates(proxy, (Object)contextObject, engine);
                return this.getMatchingEObject(uri, contextObject, candidates);
            }
        }
        catch (IncQueryException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
        return null;
    }

    public EObject getEObject(URI uri, ExtendedResourceSet contextResourceSet, Object contextObject, boolean loadOnDemand) {
        try {
            if (contextResourceSet != null) {
                uri = contextResourceSet.trimProxyContextInfo(uri);
                IncQueryEngine engine = this.getIncQueryEngineHelper().getEngine((ResourceSet)contextResourceSet);
                EObject[] candidates = this.getEObjectCandidates(uri, contextObject, engine);
                return this.getMatchingEObject(uri, contextObject, candidates);
            }
        }
        catch (IncQueryException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
        return null;
    }
}

