# Eclipse™ Sparkplug™ TCK

This is the Eclipse Sparkplug Test Compatibility Kit (TCK). For Sparkplug certification requests, this TCK should be downloaded in binary form
from [Eclipse downloads](https://]download.eclipse.org). This README is meant to be read as part of that package.

## Listing Requests for Compatible Products

Sparkplug is a self-certification ecosystem. If you wish to have your product featured in the official list of compatible products, a listing request is required and must be approved by the Eclipse Sparkplug Specification Project Team.

There are additional requirements that MUST be met by any organization wishing to use the “Sparkplug Compatible” logo or [Sparkplug website](https://sparkplug.eclipse.org/) for promotion. Any request for listing from an organization not meeting the requirements will be held until such time as the requirements are met. See the [Sparkplug Trademark Guidelines](https://sparkplug.eclipse.org/compatibility/get-listed/documents/sparkplug-trademark-guidelines.pdf) for more information.

An approved listing request is a statement from the Specification Project that you have met the intended TCK requirements and is just one of the requirements for logo usage. 

More information on the process and requirements are available [here](https://sparkplug.eclipse.org/compatibility/get-listed/).

## Sparkplug and Sparkplug TCK Resources

* [TCK User Guide](https://github.com/eclipse-sparkplug/sparkplug/blob/develop/tck/UserGuide.adoc)

* Test coverage document: coverage-report/coverage-sparkplug.html

* [Eclipse Tahu Sparkplug Compatible Implementations Guide](https://github.com/eclipse/tahu/blob/master/java/README.md)

* Request a new [Sparkplug Product Listing](https://github.com/eclipse-sparkplug/sparkplug.listings/issues/new?assignees=&labels=getlisted%2Ctriage&template=GET-LISTED.yml&title=Get+Listed+Request%3A+%5BADD+DETAILS+HERE%5D)

* [Report a bug](https://github.com/eclipse-sparkplug/sparkplug/issues/new?assignees=&labels=bugreport%2Ctriage&template=BUG-REPORT.yml&title=Bug+Report%3A+%5BADD+DETAILS+HERE%5D) in the Sparkplug TCK

* [Ask a question](https://github.com/eclipse-sparkplug/sparkplug/issues/new?assignees=&labels=question%2Ctriage&template=QUESTION.yml&title=Question%3A+%5BADD+SUMMARY+HERE%5D) about Sparkplug or the Sparkplug TCK

