/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.component.componentParameter.ui.quickfix;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesFactory;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterTypeConformance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ui.quickfix.ParameterDefinitionQuickfixProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentParameterQuickfixProvider
extends ParameterDefinitionQuickfixProvider {
    @Inject
    private ComponentParameterTypeConformance conf;
    @Inject
    private BasicAttributesModelUtility util;

    @Fix(value="org.xtext.component.componentParameter.MissingAttributeRefinements")
    public void addMissingAttributeRefinements(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            ParameterInstance param = (ParameterInstance)element;
            Consumer<AttributeDefinition> _function_1 = attribute -> {
                boolean _not;
                Functions.Function1 _function_2 = ref -> ref.getAttribute().equals(attribute);
                boolean _exists = IterableExtensions.exists((Iterable)param.getAttributes(), (Functions.Function1)_function_2);
                boolean bl = _not = !_exists;
                if (_not) {
                    boolean _tripleNotEquals;
                    AttributeRefinement attrRef = BasicAttributesFactory.eINSTANCE.createAttributeRefinement();
                    attrRef.setAttribute(attribute);
                    AbstractValue _defaultvalue = attribute.getDefaultvalue();
                    boolean bl2 = _tripleNotEquals = _defaultvalue != null;
                    if (_tripleNotEquals) {
                        attrRef.setValue(attribute.getDefaultvalue());
                    } else {
                        attrRef.setValue(this.conf.createPrimitiveDefaultValue(attribute.getType()));
                    }
                    param.getAttributes().add((Object)attrRef);
                }
            };
            param.getParameterDef().getAttributes().forEach(_function_1);
        };
        acceptor.accept(issue, "Add missing attribute-refinements", "Add missing attribute-refinements.", "", _function);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof XtextEditor) {
            ISourceViewer _internalSourceViewer = ((XtextEditor)editor).getInternalSourceViewer();
            ((SourceViewer)_internalSourceViewer).doOperation(15);
        }
    }

    @Fix(value="org.xtext.component.componentParameter.SingleParamSetInstance")
    public void fixMultipleParamSetInstances(Issue issue, IssueResolutionAcceptor acceptor) {
        String _get = issue.getData()[0];
        String _plus = "Remove ParameterSetInstance \"" + _get;
        String _plus_1 = String.valueOf(_plus) + "\".";
        ISemanticModification _function = (element, context) -> {
            EObject _eContainer = element.eContainer();
            ComponentParameter param = (ComponentParameter)_eContainer;
            param.getParameters().remove((Object)element);
        };
        acceptor.accept(issue, "Remove ParameterSetInstance", _plus_1, "", _function);
    }

    @Fix(value="org.xtext.component.componentParameter.ParameterSetInstanceMatchBehaviorInterface")
    public void fixParameterSetInstanceMatchComponentBehaviorSlaveInterface(Issue issue, IssueResolutionAcceptor acceptor) {
        String _get = issue.getData()[0];
        String _plus = "Change ParameterSetInstance to \"" + _get;
        String _plus_1 = String.valueOf(_plus) + "\".";
        String _get_1 = issue.getData()[0];
        String _plus_2 = "Change ParameterSetInstance to \"" + _get_1;
        String _plus_3 = String.valueOf(_plus_2) + "\".";
        IModification _function = context -> {
            IXtextDocument doc = context.getXtextDocument();
            doc.replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
        };
        acceptor.accept(issue, _plus_1, _plus_3, "", _function);
    }

    @Fix(value="org.xtext.component.componentParameter.MissingAttributeValue")
    public void fixMisingAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            IXtextDocument doc = context.getXtextDocument();
            AttributeDefinition attr = (AttributeDefinition)element;
            Integer _offset = issue.getOffset();
            Integer _length = issue.getLength();
            int _plus = _offset + _length;
            String _get = ((String[])Conversions.unwrapArray((Object)this.util.getDefaultValuesFor(attr.getType()), String.class))[0];
            String _plus_1 = " = " + _get;
            String _plus_2 = String.valueOf(_plus_1) + "\n";
            doc.replace(_plus, 1, _plus_2);
        };
        acceptor.accept(issue, "Add default attribute value", "Add default attribute value", "", _function);
    }
}

