/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class GenericDatasheetUtils {
  public static Collection<String> getSpdxLicenseNames() {
    final ArrayList<String> result = CollectionLiterals.<String>newArrayList();
    try {
      String _name = GenericDatasheetUtils.class.getPackage().getName();
      String _plus = ("platform:/plugin/" + _name);
      final String uri = (_plus + "/spdx-licenses.txt");
      URL url = new URL(uri);
      final InputStream inputStream = url.openConnection().getInputStream();
      InputStreamReader _inputStreamReader = new InputStreamReader(inputStream);
      final BufferedReader in = new BufferedReader(_inputStreamReader);
      String inputLine = null;
      while (((inputLine = in.readLine()) != null)) {
        result.add(inputLine);
      }
      in.close();
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return result;
  }
}
