/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.quickfix;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionFactory;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PublicOperationMode;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.validation.ComponentDefinitionValidator;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.ui.quickfix.RoboticMiddlewareQuickfixProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class ComponentDefinitionQuickfixProvider extends RoboticMiddlewareQuickfixProvider {
  @Fix(ComponentDefinitionValidator.DUPLICATE_ACTIVATION_CONSTRAINTS)
  public void fixDuplicateActivationConstraints(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final Activity activity = ((Activity) _eContainer);
      activity.getExtensions().remove(element);
    };
    acceptor.accept(issue, 
      "Remove duplicate ActivationConstraints", 
      "Remove duplicate ActivationConstraints.", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.DUPLICATE_OPERATION_MODE_BINDING)
  public void fixDuplicateOperationModeBinding(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final Activity activity = ((Activity) _eContainer);
      activity.getExtensions().remove(element);
    };
    acceptor.accept(issue, 
      "Remove duplicate OperationModeBinding", 
      "Remove duplicate OperationModeBinding.", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.DEFAULT_TIMED_TRIGGER_MIN_FREQUENCY)
  public void fixMinDefaultFrequency(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    String _plus = ("Set periodic activation-frequency to " + _get);
    String _get_1 = issue.getData()[0];
    String _plus_1 = ("Set periodic activation-frequency to " + _get_1);
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final DefaultPeriodicTimer timer = ((DefaultPeriodicTimer) element);
      timer.setPeriodicActFreq(Double.parseDouble(issue.getData()[0]));
    };
    acceptor.accept(issue, _plus, _plus_1, "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.DEFAULT_TIMED_TRIGGER_MAX_FREQUENCY)
  public void fixMaxDefaultFrequency(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    String _plus = ("Set periodic activation-frequency to " + _get);
    String _get_1 = issue.getData()[0];
    String _plus_1 = ("Set periodic activation-frequency to " + _get_1);
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final DefaultPeriodicTimer timer = ((DefaultPeriodicTimer) element);
      timer.setPeriodicActFreq(Double.parseDouble(issue.getData()[0]));
    };
    acceptor.accept(issue, _plus, _plus_1, "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.MULTIPLE_DEFAULT_OPERATION_MODES)
  public void unsetDefaultFlagForPublicOperationMode(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final PublicOperationMode mode = ((PublicOperationMode) element);
      mode.setIsDefaultInit(false);
    };
    acceptor.accept(issue, 
      "Unset the default flag", 
      "Unset the default flag", 
      "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.PRIVATE_OPERATION_MODE_NAME)
  public void smallLetterPrivateOperationModeName(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _firstLower = StringExtensions.toFirstLower(issue.getData()[0]);
    String _plus = ("Change PrivateOperationMode name to \'" + _firstLower);
    String _plus_1 = (_plus + "\'");
    String _firstLower_1 = StringExtensions.toFirstLower(issue.getData()[0]);
    String _plus_2 = ("Change PrivateOperationMode name to \'" + _firstLower_1);
    String _plus_3 = (_plus_2 + "\'");
    final IModification _function = (IModificationContext context) -> {
      final IXtextDocument doc = context.getXtextDocument();
      final String firstLetter = doc.get((issue.getOffset()).intValue(), 1);
      doc.replace((issue.getOffset()).intValue(), 1, StringExtensions.toFirstLower(firstLetter));
    };
    acceptor.accept(issue, _plus_1, _plus_3, 
      "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.DUPLICATE_PARAMETER_STRUCT)
  public void fixDuplicateParameterStruct(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final ComponentDefinition component = ((ComponentDefinition) _eContainer);
      component.getElements().remove(element);
    };
    acceptor.accept(issue, 
      "Remove duplicate ParameterStruct", 
      "Remove duplicate ParameterStruct.", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.ACTIVITY_OBSERVATION_CYLE)
  public void fixActivityObservationCycle(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final Activity activity = ((Activity) _eContainer);
      activity.getLinks().remove(element);
    };
    acceptor.accept(issue, 
      "Remove cyclic ActivityObserver", 
      "Remove cyclic ActivityObserver.", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.MULTIPLE_DEFAULT_MIDDLEWARES)
  public void fixDuplicateDefaultMiddlewares(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    String _plus = ("Remove \"default\" flag from Middleware " + _get);
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final SupportedMiddleware middleware = ((SupportedMiddleware) element);
      middleware.setDefault(false);
    };
    acceptor.accept(issue, 
      "Remove \"default\" flag from Middleware", _plus, "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.MULTIPLE_DEFAULT_TRIGGERS)
  public void fixDuplicateDefaultTriggers(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final Activity activity = ((Activity) _eContainer);
      activity.getExtensions().remove(element);
    };
    acceptor.accept(issue, 
      "Remove duplicate DefaultTrigger", 
      "Remove duplicate DefaultTrigger", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.INPUT_HANDLER_LINK)
  public void fixInputHandlerLink(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final InputHandler handler = ((InputHandler) _eContainer);
      handler.getLinks().remove(element);
    };
    acceptor.accept(issue, 
      "Remove duplicate InputPortLink", 
      "Remove duplicate InputPortLink", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.DUPLICATE_REALIZATIONS_COORDINATION_SLAVE_PORT)
  public void fixDuplicateCommunicationServiceRealization(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final CoordinationSlavePort coordinationSlavePort = ((CoordinationSlavePort) _eContainer);
      coordinationSlavePort.getElements().remove(element);
    };
    acceptor.accept(issue, 
      "Remove duplicate CommunicationServiceRealization", 
      "Remove duplicate CommunicationServiceRealization.", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.MISSING_REQUEST_HANDLER)
  public void fixMissingRequestHandler(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final AnswerPort port = ((AnswerPort) element);
      EObject _eContainer = element.eContainer();
      final ComponentDefinition component = ((ComponentDefinition) _eContainer);
      final RequestHandler handler = ComponentDefinitionFactory.eINSTANCE.createRequestHandler();
      handler.setAnswerPort(port);
      String _name = port.getName();
      String _plus = (_name + "Handler");
      handler.setName(_plus);
      component.getElements().add(handler);
    };
    acceptor.accept(issue, 
      "Create a default RequestHandler", 
      "Create a default RequestHandler", "", _function);
  }
  
  @Fix(ComponentDefinitionValidator.PASSIVE_REQUEST_HANDLER)
  public void fixPassiveRequestHandler(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final RequestHandler handler = ((RequestHandler) element);
      handler.setActiveQueue(true);
    };
    acceptor.accept(issue, 
      "Make RequestHandler active", 
      "Make RequestHandler active", "", _function);
  }
}
