/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ActivityExtension;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefModel;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ServiceRepoImport;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.formatting2.RoboticMiddlewareFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ComponentDefinitionFormatter extends RoboticMiddlewareFormatter {
  protected void _format(final ComponentDefModel componentDefModel, @Extension final IFormattableDocument document) {
    document.<ComponentDefinition>format(componentDefModel.getComponent());
    EList<ServiceRepoImport> _imports = componentDefModel.getImports();
    for (final ServiceRepoImport imp : _imports) {
      {
        document.<ServiceRepoImport>format(imp);
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<ServiceRepoImport>append(imp, _function);
      }
    }
  }
  
  protected void _format(final ComponentDefinition componentDefinition, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(componentDefinition).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(componentDefinition).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    EList<AbstractComponentElement> _elements = componentDefinition.getElements();
    for (final AbstractComponentElement elem : _elements) {
      {
        document.<AbstractComponentElement>format(elem);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<AbstractComponentElement>append(elem, _function_3);
      }
    }
  }
  
  protected void _format(final Activity activity, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(activity).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(activity).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_2);
    EList<AbstractComponentLink> _links = activity.getLinks();
    for (final AbstractComponentLink il : _links) {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, 2);
      };
      document.<AbstractComponentLink>append(il, _function_3);
    }
    EList<ActivityExtension> _extensions = activity.getExtensions();
    for (final ActivityExtension ext : _extensions) {
      {
        document.<ActivityExtension>format(ext);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<ActivityExtension>append(ext, _function_4);
      }
    }
  }
  
  protected void _format(final ActivationConstraints constraints, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(constraints).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(constraints).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(constraints).keyword("="), _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(this.textRegionExtensions.regionFor(constraints).keyword("minActFreq"), _function_3);
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(this.textRegionExtensions.regionFor(constraints).keyword("maxActFreq"), _function_4);
    final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(close, _function_5);
  }
  
  protected void _format(final ComponentPort service, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(service).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(service).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(close, _function_2);
  }
  
  protected void _format(final RequestHandler handler, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(handler).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(handler).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
    EList<AbstractComponentLink> _links = handler.getLinks();
    for (final AbstractComponentLink obs : _links) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, 2);
      };
      document.<AbstractComponentLink>append(obs, _function_2);
    }
  }
  
  protected void _format(final CoordinationSlavePort port, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(port).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(port).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(close, _function_3);
  }
  
  public void format(final Object activity, final IFormattableDocument document) {
    if (activity instanceof Activity) {
      _format((Activity)activity, document);
      return;
    } else if (activity instanceof RequestHandler) {
      _format((RequestHandler)activity, document);
      return;
    } else if (activity instanceof ComponentPort) {
      _format((ComponentPort)activity, document);
      return;
    } else if (activity instanceof CoordinationSlavePort) {
      _format((CoordinationSlavePort)activity, document);
      return;
    } else if (activity instanceof XtextResource) {
      _format((XtextResource)activity, document);
      return;
    } else if (activity instanceof ComponentDefinition) {
      _format((ComponentDefinition)activity, document);
      return;
    } else if (activity instanceof ActivationConstraints) {
      _format((ActivationConstraints)activity, document);
      return;
    } else if (activity instanceof ComponentDefModel) {
      _format((ComponentDefModel)activity, document);
      return;
    } else if (activity instanceof EObject) {
      _format((EObject)activity, document);
      return;
    } else if (activity == null) {
      _format((Void)null, document);
      return;
    } else if (activity != null) {
      _format(activity, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(activity, document).toString());
    }
  }
}
