/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.base.basicAttributes;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BoolValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.FloatingPointValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.IntValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.StringValue;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BasicAttributesModelUtility {
    public String getValueString(AbstractValue av) {
        String _switchResult = null;
        boolean _matched = false;
        if (av instanceof IntValue) {
            _matched = true;
            _switchResult = Integer.valueOf(((IntValue)av).getValue()).toString();
        }
        if (!_matched && av instanceof FloatingPointValue) {
            _matched = true;
            _switchResult = Double.valueOf(((FloatingPointValue)av).getValue()).toString();
        }
        if (!_matched && av instanceof StringValue) {
            _matched = true;
            String _value = ((StringValue)av).getValue();
            String _plus = "\"" + _value;
            _switchResult = String.valueOf(_plus) + "\"";
        }
        if (!_matched && av instanceof BoolValue) {
            _matched = true;
            _switchResult = Boolean.valueOf(((BoolValue)av).isValue()).toString();
        }
        if (!_matched && av instanceof EnumerationValue) {
            _matched = true;
            _switchResult = ((EnumerationValue)av).getValue().getName();
        }
        if (!_matched && av instanceof ArrayValue) {
            _matched = true;
            EList<SingleValue> _values = ((ArrayValue)av).getValues();
            List _map = null;
            if (_values != null) {
                Functions.Function1 _function = it -> this.getValueString((AbstractValue)it);
                _map = ListExtensions.map(_values, (Functions.Function1)_function);
            }
            String _join = IterableExtensions.join(_map, (CharSequence)", ");
            String _plus = "[" + _join;
            _switchResult = String.valueOf(_plus) + "]";
        }
        return _switchResult;
    }

    public Iterable<String> getDefaultValuesFor(AbstractAttributeType type) {
        ArrayList textList = CollectionLiterals.newArrayList();
        if (type instanceof PrimitiveType) {
            PRIMITIVE_TYPE_NAME _typeName_5;
            boolean _equals_3;
            PRIMITIVE_TYPE_NAME _typeName_4;
            boolean _equals_2;
            PRIMITIVE_TYPE_NAME _typeName_3;
            boolean _equals_1;
            PRIMITIVE_TYPE_NAME _typeName_2;
            boolean _equals;
            boolean _lessEqualsThan;
            ((PrimitiveType)type).getTypeName();
            boolean _matched = false;
            PRIMITIVE_TYPE_NAME _typeName_1 = ((PrimitiveType)type).getTypeName();
            boolean bl = _lessEqualsThan = _typeName_1.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0;
            if (_lessEqualsThan) {
                _matched = true;
                textList.add("0");
            }
            if (!_matched && (_equals = Objects.equal((Object)((Object)(_typeName_2 = ((PrimitiveType)type).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.FLOAT)))) {
                _matched = true;
                textList.add("1.0");
            }
            if (!_matched && (_equals_1 = Objects.equal((Object)((Object)(_typeName_3 = ((PrimitiveType)type).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.DOUBLE)))) {
                _matched = true;
                CollectionExtensions.addAll((Collection)textList, (Object[])new String[]{"1.0", "0"});
            }
            if (!_matched && (_equals_2 = Objects.equal((Object)((Object)(_typeName_4 = ((PrimitiveType)type).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.STRING)))) {
                _matched = true;
                textList.add("\"Text\"");
            }
            if (!_matched && (_equals_3 = Objects.equal((Object)((Object)(_typeName_5 = ((PrimitiveType)type).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.BOOLEAN)))) {
                _matched = true;
                CollectionExtensions.addAll((Collection)textList, (Object[])new String[]{"true", "false"});
            }
        } else if (type instanceof InlineEnumerationType) {
            EList<EnumerationElement> _enums = ((InlineEnumerationType)type).getEnums();
            for (EnumerationElement en : _enums) {
                textList.add(en.getName());
            }
        }
        return textList;
    }

    public String getTypeName(AbstractAttributeType attrType) {
        String _switchResult = null;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)attrType).getTypeName().getLiteral();
        }
        if (!_matched && attrType instanceof InlineEnumerationType) {
            _matched = true;
            _switchResult = "InlineEnumeration";
        }
        return _switchResult;
    }

    public boolean isOctetType(AbstractAttributeType attrType) {
        PRIMITIVE_TYPE_NAME _typeName;
        boolean _equals;
        boolean _switchResult = false;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.UINT8)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isRealType(AbstractAttributeType attrType) {
        PRIMITIVE_TYPE_NAME _typeName;
        boolean _equals;
        boolean _switchResult = false;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.FLOAT)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.DOUBLE)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isBooleanType(AbstractAttributeType attrType) {
        PRIMITIVE_TYPE_NAME _typeName;
        boolean _equals;
        boolean _switchResult = false;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.BOOLEAN)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isStringType(AbstractAttributeType attrType) {
        PRIMITIVE_TYPE_NAME _typeName;
        boolean _equals;
        boolean _switchResult = false;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.STRING)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isLonglongType(AbstractAttributeType attrType) {
        PRIMITIVE_TYPE_NAME _typeName;
        boolean _equals;
        boolean _switchResult = false;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.INT64)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && attrType instanceof PrimitiveType && (_equals = Objects.equal((Object)((Object)(_typeName = ((PrimitiveType)attrType).getTypeName())), (Object)((Object)PRIMITIVE_TYPE_NAME.UINT64)))) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public Boolean isArrayType(AttributeDefinition attr) {
        ArrayType _array = attr.getType().getArray();
        return _array != null;
    }

    public Boolean haveEnums(Collection<AttributeDefinition> attributes) {
        Functions.Function1 _function = it -> {
            AbstractAttributeType _type = it.getType();
            return _type instanceof InlineEnumerationType;
        };
        return IterableExtensions.exists(attributes, (Functions.Function1)_function);
    }
}

