/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.transform;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.PlanPro.util.IDReference;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Utilities for working with IDReferences
 * 
 * @author Stuecker
 */
@SuppressWarnings("all")
public class IDReferenceUtils {
  /**
   * Retargets ID References onto a new object
   * 
   * When copying an EObject (for example during importing), the ID References
   * from the source need to be updated to point to the newly created model
   * 
   * IMPROVE: Create an EObject copier which does this automatically to improve performance
   * 
   * @param source
   * @param target
   * @param references The references to retarget
   * @param outReferences The list to insert the retargeted ID references
   */
  public static void retargetIDReferences(final EObject source, final EObject target, final Iterable<IDReference> references, final List<IDReference> outReferences) {
    if (((source == null) || (target == null))) {
      return;
    }
    final Function1<IDReference, Boolean> _function = new Function1<IDReference, Boolean>() {
      @Override
      public Boolean apply(final IDReference it) {
        EObject _target = it.target();
        return Boolean.valueOf((_target == source));
      }
    };
    final Function1<IDReference, IDReference> _function_1 = new Function1<IDReference, IDReference>() {
      @Override
      public IDReference apply(final IDReference ref) {
        String _guid = ref.guid();
        EObject _source = ref.source();
        EReference _sourceRef = ref.sourceRef();
        EReference _targetRef = ref.targetRef();
        return new IDReference(_guid, _source, _sourceRef, target, _targetRef);
      }
    };
    final Consumer<IDReference> _function_2 = new Consumer<IDReference>() {
      @Override
      public void accept(final IDReference it) {
        outReferences.add(it);
      }
    };
    IterableExtensions.<IDReference, IDReference>map(IterableExtensions.<IDReference>filter(references, _function), _function_1).forEach(_function_2);
    final Function1<EReference, Boolean> _function_3 = new Function1<EReference, Boolean>() {
      @Override
      public Boolean apply(final EReference it) {
        return Boolean.valueOf(it.isContainment());
      }
    };
    final Consumer<EReference> _function_4 = new Consumer<EReference>() {
      @Override
      public void accept(final EReference ref) {
        boolean _isMany = ref.isMany();
        boolean _not = (!_isMany);
        if (_not) {
          Object _eGet = source.eGet(ref);
          final EObject sourceChild = ((EObject) _eGet);
          Object _eGet_1 = target.eGet(ref);
          final EObject targetChild = ((EObject) _eGet_1);
          IDReferenceUtils.retargetIDReferences(sourceChild, targetChild, references, outReferences);
        } else {
          Object _eGet_2 = source.eGet(ref);
          final EList<?> sourceChildren = ((EList<?>) _eGet_2);
          Object _eGet_3 = target.eGet(ref);
          final EList<?> targetChildren = ((EList<?>) _eGet_3);
          final Consumer<Ur_Objekt> _function = new Consumer<Ur_Objekt>() {
            @Override
            public void accept(final Ur_Objekt sourceChild_1) {
              final Function1<Ur_Objekt, Boolean> _function = new Function1<Ur_Objekt, Boolean>() {
                @Override
                public Boolean apply(final Ur_Objekt targetChild_1) {
                  Identitaet_TypeClass _identitaet = null;
                  if (sourceChild_1!=null) {
                    _identitaet=sourceChild_1.getIdentitaet();
                  }
                  String _wert = null;
                  if (_identitaet!=null) {
                    _wert=_identitaet.getWert();
                  }
                  Identitaet_TypeClass _identitaet_1 = null;
                  if (targetChild_1!=null) {
                    _identitaet_1=targetChild_1.getIdentitaet();
                  }
                  String _wert_1 = null;
                  if (_identitaet_1!=null) {
                    _wert_1=_identitaet_1.getWert();
                  }
                  return Boolean.valueOf(Objects.equal(_wert, _wert_1));
                }
              };
              final Ur_Objekt targetChild = IterableExtensions.<Ur_Objekt>findFirst(Iterables.<Ur_Objekt>filter(targetChildren, Ur_Objekt.class), _function);
              IDReferenceUtils.retargetIDReferences(sourceChild_1, targetChild, references, outReferences);
            }
          };
          Iterables.<Ur_Objekt>filter(sourceChildren, Ur_Objekt.class).forEach(_function);
        }
      }
    };
    IterableExtensions.<EReference>filter(Iterables.<EReference>filter(source.eClass().getEStructuralFeatures(), EReference.class), _function_3).forEach(_function_4);
  }
}
