/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.Activator;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStatusField;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStatusHtmlProvider;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.shared.WebClientState;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.osgi.framework.Bundle;

public class DefaultWizardStatusHtmlProvider
implements IWizardStatusHtmlProvider {
    private String m_htmlTemplate;

    @Override
    public void initialize(AbstractWizardStatusField htmlField) throws ProcessingException {
        try {
            this.m_htmlTemplate = new String(IOUtility.getContent((InputStream)Activator.getDefault().getBundle().getResource("resources/html/defaultWizardStatus.html").openStream()), "iso-8859-1");
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected", t);
        }
        List<RemoteFile> attachments = this.collectAttachments();
        if (attachments != null && attachments.size() > 0) {
            htmlField.setAttachments(attachments.toArray(new RemoteFile[attachments.size()]));
        }
    }

    @Override
    public String createHtml(IWizard w) throws ProcessingException {
        String html = this.m_htmlTemplate;
        String topPart = "";
        String bottomPart = "";
        StringBuilder listPart = new StringBuilder();
        if (w != null) {
            if (w.getTooltipText() != null) {
                topPart = "<div class=\"infoBox\">" + StringUtility.nvl((Object)w.getTitleHtml(), (String)w.getTooltipText()) + "</div>";
            }
            if (w.getActiveStep() != null && (w.getActiveStep().getTooltipText() != null || w.getActiveStep().getDescriptionHtml() != null)) {
                bottomPart = "<div class=\"infoBox\">" + StringUtility.nvl((Object)w.getActiveStep().getDescriptionHtml(), (String)w.getActiveStep().getTooltipText()) + "</div>";
            }
            int index = 1;
            Iterator<IWizardStep<? extends IForm>> iterator = w.getSteps().iterator();
            while (iterator.hasNext()) {
                IWizardStep<? extends IForm> step;
                String s = this.createHtmlForStep(step, index, (step = iterator.next()) == w.getActiveStep());
                listPart.append(s);
                ++index;
            }
        }
        html = html.replace("#FONT_SIZE_UNIT#", WebClientState.getFontSizeUnit());
        html = html.replace("#TOP#", topPart);
        html = html.replace("#LIST#", listPart.toString());
        html = html.replace("#BOTTOM#", bottomPart);
        return html;
    }

    protected String createHtmlForStep(IWizardStep<?> step, int index, boolean selected) {
        String cssClass = selected ? "selected" : (step.isEnabled() ? "default" : "disabled");
        StringBuilder buf = new StringBuilder();
        String spacerCssClass = "selected".equals(cssClass) ? "spacerselected" : "spacer";
        this.appendHtmlForSpacerLine(buf, spacerCssClass, 7);
        buf.append("<tr class=\"" + cssClass + "\">\n");
        buf.append(" <td width=\"15\"><img src=\"empty.png\" width=\"1\" height=\"30\"></td>\n");
        buf.append(" <td width=\"24\" valign=\"top\" class=\"bullet\" style=\"padding:4px;\">" + index + "</td>\n");
        buf.append(" <td width=\"17\"></td>\n");
        buf.append(" <td style=\"padding-top:2px;\">" + StringUtility.nvl((Object)step.getTitleHtml(), (String)step.getTitle()) + "</td>\n");
        buf.append(" <td width=\"15\"></td>\n");
        buf.append("</tr>\n");
        this.appendHtmlForSpacerLine(buf, spacerCssClass, 11);
        this.appendHtmlForSpacerLine(buf, "line", 1);
        return buf.toString();
    }

    protected void appendHtmlForSpacerLine(StringBuilder buf, String cssClass, int height) {
        buf.append("<tr class=\"" + cssClass + "\"><td colspan=\"5\"><img src=\"empty.png\" width=\"1\" height=\"" + height + "\"></td></tr>\n");
    }

    protected List<RemoteFile> collectAttachments() {
        Bundle clientBundle = Activator.getDefault().getBundle();
        LinkedList<RemoteFile> attachments = new LinkedList<RemoteFile>();
        attachments.add(new RemoteFile(clientBundle.getResource("resources/icons/empty.png"), true));
        attachments.add(new RemoteFile(clientBundle.getResource("resources/icons/wiz_bullet.png"), true));
        attachments.add(new RemoteFile(clientBundle.getResource("resources/icons/wiz_bullet_disabled.png"), true));
        attachments.add(new RemoteFile(clientBundle.getResource("resources/icons/wiz_bullet_selected.png"), true));
        return attachments;
    }
}

