/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.internal;

import java.util.TreeMap;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;

public class FindFieldByFormDataIdVisitor
implements IFormFieldVisitor {
    private String[] m_fieldIdParts;
    private TreeMap<Integer, IFormField> m_prioMap;

    public FindFieldByFormDataIdVisitor(String fieldId) {
        this.m_fieldIdParts = fieldId.split("[/]");
        this.m_prioMap = new TreeMap();
    }

    @Override
    public boolean visitField(IFormField field, int level, int fieldIndex) {
        if (this.matchesAllParts(field)) {
            if (field instanceof IValueField) {
                this.m_prioMap.put(0, field);
            } else if (!(field instanceof ICompositeField)) {
                this.m_prioMap.put(1, field);
            } else {
                this.m_prioMap.put(2, field);
            }
        }
        return !this.m_prioMap.containsKey(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesAllParts(IFormField f) {
        int i = this.m_fieldIdParts.length - 1;
        if (!this.m_fieldIdParts[i].equals(f.getFieldId())) {
            return false;
        }
        --i;
        f = f.getParentField();
        while (i >= 0 && f != null) {
            if (this.m_fieldIdParts[i].equals(f.getFieldId())) {
                --i;
            }
            f = f.getParentField();
        }
        return i < 0;
    }

    public IFormField getField() {
        return this.m_prioMap.size() > 0 ? this.m_prioMap.get(this.m_prioMap.firstKey()) : null;
    }
}

