/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField;

public abstract class AbstractIntegerColumn
extends AbstractColumn<Integer>
implements IIntegerColumn {
    private String m_format;
    private boolean m_groupingUsed;
    private NumberFormat m_fmt;

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @ConfigProperty(value="STRING")
    @Order(value=140.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        this.m_fmt = null;
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setGroupingUsed(boolean b) {
        this.m_groupingUsed = b;
        this.m_fmt = null;
    }

    @Override
    public boolean isGroupingUsed() {
        return this.m_groupingUsed;
    }

    @Override
    protected Integer parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Integer validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Integer) {
            validValue = (Integer)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).intValue();
        } else {
            throw new ProcessingException("invalid Integer value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractIntegerField f = new AbstractIntegerField(){};
        f.setFormat(this.getFormat());
        f.setGroupingUsed(this.isGroupingUsed());
        return f;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getNumberFormat().format(((Integer)cell.getValue()).intValue()));
        } else {
            cell.setText("");
        }
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (this.m_fmt == null) {
            if (this.getFormat() != null) {
                DecimalFormat x = (DecimalFormat)DecimalFormat.getNumberInstance();
                x.applyPattern(this.getFormat());
                x.setMinimumFractionDigits(0);
                x.setMaximumFractionDigits(0);
                this.m_fmt = x;
            } else {
                this.m_fmt = NumberFormat.getNumberInstance();
                this.m_fmt.setMinimumFractionDigits(0);
                this.m_fmt.setMaximumFractionDigits(0);
                this.m_fmt.setGroupingUsed(this.isGroupingUsed());
            }
        }
        return this.m_fmt;
    }
}

