/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class TableRow
implements ITableRow {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableRow.class);
    private final ColumnSet m_columnSet;
    private int m_status = 0;
    private boolean m_enabled;
    private boolean m_checked;
    private final ArrayList<Cell> m_cells;
    private boolean m_rowPropertiesChanged;
    private int m_rowChanging = 0;

    public TableRow(ColumnSet columnSet) {
        this.m_columnSet = columnSet;
        this.m_enabled = true;
        this.m_status = 0;
        int colCount = columnSet != null ? columnSet.getColumnCount() : 0;
        this.m_cells = new ArrayList(colCount);
        int i = 0;
        while (i < colCount) {
            this.m_cells.add(new Cell());
            ++i;
        }
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTableRow(this);
        }
    }

    public TableRow(ColumnSet columnSet, Object[] values) throws ProcessingException {
        this(columnSet);
        if (values == null) {
            values = new Object[]{};
        }
        int i = 0;
        while (i < values.length) {
            Cell cell = this.getCellForUpdate(i);
            cell.setValue(values[i]);
            ++i;
        }
    }

    @Override
    public int getRowIndex() {
        return -1;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public void setStatusInserted() {
        this.setStatus(1);
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public void setStatusUpdated() {
        this.setStatus(2);
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public void setStatusDeleted() {
        this.setStatus(3);
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public void setStatusNonchanged() {
        this.setStatus(0);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabled = b;
        int i = 0;
        while (i < this.m_cells.size()) {
            this.m_cells.get(i).setEnabled(b);
            ++i;
        }
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isChecked() {
        return this.m_checked;
    }

    @Override
    public void setChecked(boolean b) {
        this.m_checked = b;
    }

    @Override
    public boolean isFilterAccepted() {
        return true;
    }

    @Override
    public int getCellCount() {
        return this.m_cells.size();
    }

    @Override
    public ICell getCell(IColumn column) {
        return this.getCell(column.getColumnIndex());
    }

    @Override
    public ICell getCell(int columnIndex) {
        if (columnIndex < this.m_cells.size()) {
            return this.m_cells.get(columnIndex);
        }
        return null;
    }

    @Override
    public void setCell(IColumn column, ICell cell) throws ProcessingException {
        this.setCell(column.getColumnIndex(), cell);
    }

    @Override
    public void setCell(int columnIndex, ICell cell) throws ProcessingException {
        if (cell != null) {
            this.getCellForUpdate(columnIndex);
            this.m_cells.set(columnIndex, new Cell(null, cell));
        }
    }

    @Override
    public Cell getCellForUpdate(IColumn column) {
        return this.getCellForUpdate(column.getColumnIndex());
    }

    @Override
    public Cell getCellForUpdate(int columnIndex) {
        while (columnIndex >= this.m_cells.size()) {
            this.m_cells.add(new Cell());
        }
        return this.m_cells.get(columnIndex);
    }

    @Override
    public Object getCellValue(int columnIndex) {
        ICell cell = this.getCell(columnIndex);
        if (cell != null) {
            return cell.getValue();
        }
        return null;
    }

    @Override
    public Object[] getKeyValues() {
        if (this.m_columnSet == null) {
            throw new UnsupportedOperationException("can only be called when TableRow was constructed with a non-null columnSet");
        }
        int[] keyColumns = this.m_columnSet.getKeyColumnIndexes();
        if (keyColumns.length == 0) {
            keyColumns = this.m_columnSet.getAllColumnIndexes();
        }
        Object[] pk = new Object[keyColumns.length];
        int i = 0;
        while (i < keyColumns.length) {
            pk[i] = this.getCellValue(keyColumns[i]);
            ++i;
        }
        return pk;
    }

    @Override
    public boolean isRowChanging() {
        return false;
    }

    @Override
    public void setRowChanging(boolean b) {
        this.m_rowChanging = b ? ++this.m_rowChanging : --this.m_rowChanging;
    }

    @Override
    public boolean setCellValue(int columnIndex, Object value) throws ProcessingException {
        try {
            this.setRowChanging(true);
            Object oldValue = this.getCellValue(columnIndex);
            if (oldValue == value || oldValue != null && oldValue.equals(value)) {
                return false;
            }
            this.getCellForUpdate(columnIndex);
            this.m_cells.get(columnIndex).setValue(value);
            if (this.isStatusNonchanged()) {
                this.setStatusUpdated();
            }
            return true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean setCellValues(Object[] values) throws ProcessingException {
        try {
            this.setRowChanging(true);
            boolean changed = false;
            int i = 0;
            while (i < values.length) {
                boolean b = this.setCellValue(i, values[i]);
                changed = changed || b;
                ++i;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public ITable getTable() {
        return null;
    }

    @Override
    public void touch() throws ProcessingException {
    }

    @Override
    public void delete() throws ProcessingException {
    }

    @Override
    public void setBackgroundColor(String c) {
        int i = 0;
        while (i < this.m_cells.size()) {
            this.m_cells.get(i).setBackgroundColor(c);
            ++i;
        }
    }

    @Override
    public void setForegroundColor(String c) {
        int i = 0;
        while (i < this.m_cells.size()) {
            this.m_cells.get(i).setForegroundColor(c);
            ++i;
        }
    }

    @Override
    public void setFont(FontSpec f) {
        int i = 0;
        while (i < this.m_cells.size()) {
            this.m_cells.get(i).setFont(f);
            ++i;
        }
    }

    @Override
    public void setTooltipText(String s) {
        int i = 0;
        while (i < this.m_cells.size()) {
            this.m_cells.get(i).setTooltipText(s);
            ++i;
        }
    }

    @Override
    public void setIconId(String id) {
        if (this.m_columnSet == null) {
            throw new UnsupportedOperationException("can only be called when TableRow was constructed with a non-null columnSet");
        }
        IColumn col = this.m_columnSet.getFirstVisibleColumn();
        if (col != null) {
            this.m_cells.get(col.getColumnIndex()).setIconId(id);
        }
    }

    @Override
    public String getIconId() {
        if (this.m_columnSet == null) {
            throw new UnsupportedOperationException("can only be called when TableRow was constructed with a non-null columnSet");
        }
        IColumn col = this.m_columnSet.getFirstVisibleColumn();
        if (col != null) {
            return this.m_cells.get(col.getColumnIndex()).getIconId();
        }
        return null;
    }

    @Override
    public void moveDown() {
    }

    @Override
    public void moveToBottom() {
    }

    @Override
    public void moveToTop() {
    }

    @Override
    public void moveUp() {
    }

    @Override
    public boolean isRowPropertiesChanged() {
        return this.m_rowPropertiesChanged;
    }

    @Override
    public void setRowPropertiesChanged(boolean b) {
        this.m_rowPropertiesChanged = b;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.m_cells;
    }
}

