/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.progress.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgress;

public class SimpleProgress
extends ProgressMonitorWrapper
implements ISimpleProgress {
    private Job m_job;
    private String m_name;
    private int m_worked = -1;

    protected SimpleProgress(Job job, IProgressMonitor monitor) {
        super(monitor);
        this.m_job = job;
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        this.m_name = name;
        this.m_worked = 0;
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        this.m_name = name;
    }

    public void worked(int work) {
        super.worked(work);
        this.m_worked += work;
    }

    @Override
    public void setProgress(String s) {
        this.setTaskName(s);
    }

    @Override
    public void setProgress(float f) {
        int delta;
        int i;
        if (this.m_worked < 0) {
            this.beginTask(this.m_name, 100);
        }
        if ((i = (int)(100.0f * f)) >= 0 && i < this.m_worked) {
            this.beginTask(this.m_name, 100);
            this.worked(i);
        }
        if ((delta = i - this.m_worked) > 0) {
            this.worked(delta);
        }
    }

    @Override
    public void setProgress(float f, String s) {
        int delta;
        int i;
        this.setTaskName(s);
        if (this.m_worked < 0) {
            this.beginTask(this.m_name, 100);
        }
        if ((i = (int)(100.0f * f)) >= 0 && i < this.m_worked) {
            this.beginTask(this.m_name, 100);
            this.worked(i);
        }
        if ((delta = i - this.m_worked) > 0) {
            this.worked(delta);
        }
    }
}

