/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.jobs.JobOSGiUtils;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class JobListeners {
    private final IListenerDoit aboutToRun = IJobChangeListener::aboutToRun;
    private final IListenerDoit awake = IJobChangeListener::awake;
    private final IListenerDoit done = IJobChangeListener::done;
    private final IListenerDoit running = IJobChangeListener::running;
    private final IListenerDoit scheduled = IJobChangeListener::scheduled;
    private final IListenerDoit sleeping = IJobChangeListener::sleeping;
    private static final int DEFAULT_JOB_LISTENER_TIMEOUT = 3000;
    public static volatile int jobListenerTimeout = 3000;
    protected final ListenerList<IJobChangeListener> global = new ListenerList(1);

    void waitAndSendEvents(InternalJob job, boolean shouldSend) {
        boolean send = shouldSend || job.eventQueueLock.isHeldByCurrentThread();
        while (!job.eventQueue.isEmpty()) {
            if (JobListeners.getJobListenerTimeout() == 0) {
                if (send) {
                    this.sendEventsAsync(job);
                }
                return;
            }
            int timeout = JobListeners.getJobListenerTimeout();
            try {
                if (job.eventQueueLock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    try {
                        job.eventQueueThread.set(Thread.currentThread());
                        if (send) {
                            this.sendEventsAsync(job);
                        }
                        job.eventQueueThread.set(null);
                        return;
                    }
                    finally {
                        job.eventQueueLock.unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            Thread eventQueueThread = job.eventQueueThread.get();
            if (eventQueueThread == null) continue;
            JobListeners.setJobListenerTimeout(0);
            StackTraceElement[] stackTrace = eventQueueThread.getStackTrace();
            String msg = "IJobChangeListener timeout detected. Further calls to IJobChangeListener may occur in random order and join(family) can return too soon. IJobChangeListener should return within " + timeout + " ms. IJobChangeListener methods should not block. Possible deadlock.";
            MultiStatus status = new MultiStatus("org.eclipse.core.jobs", 2, msg, (Throwable)new TimeoutException(msg));
            StringBuilder buf = new StringBuilder("Thread that is running the IJobChangeListener: " + eventQueueThread.getName());
            buf.append(System.lineSeparator());
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                buf.append('\t');
                buf.append("at ");
                buf.append(stackTraceElement);
                buf.append(System.lineSeparator());
                ++n2;
            }
            Status child = new Status(4, "org.eclipse.core.jobs", 2, buf.toString(), null);
            status.add((IStatus)child);
            RuntimeLog.log((IStatus)status);
        }
    }

    private void sendEventsAsync(InternalJob job) {
        JobChangeEvent event;
        while ((event = job.eventQueue.poll()) != null) {
            this.sendEvent(event);
        }
    }

    private void sendEvent(JobChangeEvent event) {
        IListenerDoit doit = event.doit;
        for (IJobChangeListener listener : this.global) {
            try {
                doit.notify(listener, event);
            }
            catch (Throwable e) {
                this.handleException(listener, e);
            }
        }
        for (IJobChangeListener listener : event.getJob().getListeners()) {
            try {
                doit.notify(listener, event);
            }
            catch (Throwable e) {
                this.handleException(listener, e);
            }
        }
    }

    private void queueEvent(JobChangeEvent event) {
        event.job.eventQueue.offer(event);
    }

    private void handleException(IJobChangeListener listener, Throwable e) {
        if (e instanceof OperationCanceledException) {
            return;
        }
        String pluginId = JobOSGiUtils.getDefault().getBundleId(listener);
        if (pluginId == null) {
            pluginId = "org.eclipse.core.jobs";
        }
        String message = NLS.bind((String)JobMessages.meta_pluginProblems, (Object)pluginId);
        RuntimeLog.log((IStatus)new Status(4, pluginId, 2, message, e));
    }

    public void add(IJobChangeListener listener) {
        this.global.add((Object)listener);
    }

    public void remove(IJobChangeListener listener) {
        this.global.remove((Object)listener);
    }

    public void queueAboutToRun(Job job) {
        this.queueEvent(new JobChangeEvent(this.aboutToRun, job));
    }

    public void queueAwake(Job job) {
        this.queueEvent(new JobChangeEvent(this.awake, job));
    }

    public void queueDone(Job job, IStatus result, boolean reschedule) {
        this.queueEvent(new JobChangeEvent(this.done, job, result, reschedule));
    }

    public void queueRunning(Job job) {
        this.queueEvent(new JobChangeEvent(this.running, job));
    }

    public void queueScheduled(Job job, long delay, boolean reschedule) {
        this.queueEvent(new JobChangeEvent(this.scheduled, job, delay, reschedule));
    }

    public void queueSleeping(Job job) {
        this.queueEvent(new JobChangeEvent(this.sleeping, job));
    }

    public static void resetJobListenerTimeout() {
        JobListeners.setJobListenerTimeout(3000);
    }

    public static int getJobListenerTimeout() {
        return jobListenerTimeout;
    }

    public static void setJobListenerTimeout(int jobListenerTimeout) {
        JobListeners.jobListenerTimeout = jobListenerTimeout;
    }

    static interface IListenerDoit {
        public void notify(IJobChangeListener var1, IJobChangeEvent var2);
    }
}

